/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.ws.feature;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.handler.WsAddressingHandlerV200508;
import be.ehealth.technicalconnector.handler.domain.WsAddressingHeader;
import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import be.ehealth.technicalconnector.ws.feature.GenericFeature;
import java.util.HashMap;
import java.util.Map;

public class WSAddressingV200508Feature
extends GenericFeature {
    private WsAddressingHeader header;

    public WSAddressingV200508Feature(WsAddressingHeader header) throws TechnicalConnectorException {
        super(true);
        WSAddressingV200508Feature.validate(header);
        this.header = header;
    }

    private static void validate(WsAddressingHeader header) throws TechnicalConnectorException {
        if (header == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, "WsAddressing object is null.");
        }
    }

    @Override
    public String getID() {
        return "be.ehealth.technicalconnector.ws.feature.wsaddressing.v200508";
    }

    @Override
    public HandlerChain getHandlers() {
        HandlerChain handlerChain = new HandlerChain();
        if (this.header != null) {
            handlerChain.register(HandlerPosition.BEFORE, new WsAddressingHandlerV200508());
        }
        return handlerChain;
    }

    @Override
    public Map<String, Object> requestParamOptions() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.header != null) {
            result.put("be.ehealth.technicalconnector.handler.WsAddressingHandlerV200508.use", Boolean.TRUE);
            result.put("be.ehealth.technicalconnector.handler.WsAddressingHandlerV200508", this.header);
        }
        return result;
    }
}

