/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core;

import java.util.concurrent.atomic.AtomicInteger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.powermock.reflect.internal.TypeUtils;

public class ConcreteClassGenerator {
    private static AtomicInteger counter = new AtomicInteger(0);

    public Class<?> createConcreteSubClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        if (!java.lang.reflect.Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException("clazz must be abstract");
        }
        ClassPool classpool = ClassPool.getDefault();
        String originalClassName = clazz.getName();
        CtClass newClass = classpool.makeClass(this.generateClassName(clazz));
        try {
            newClass.setSuperclass(classpool.get(clazz.getName()));
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        try {
            CtMethod[] declaredMethods;
            CtClass originalClassAsCtClass = classpool.get(originalClassName);
            for (CtMethod ctMethod : declaredMethods = originalClassAsCtClass.getDeclaredMethods()) {
                if (!Modifier.isAbstract((int)ctMethod.getModifiers())) continue;
                String code = this.getReturnCode(ctMethod.getReturnType());
                CtNewMethod.make((CtClass)ctMethod.getReturnType(), (String)ctMethod.getName(), (CtClass[])ctMethod.getParameterTypes(), (CtClass[])ctMethod.getExceptionTypes(), (String)code, (CtClass)newClass);
            }
            if (!this.hasInheritableConstructor(originalClassAsCtClass)) {
                return null;
            }
            return newClass.toClass(this.getClass().getClassLoader(), this.getClass().getProtectionDomain());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasInheritableConstructor(CtClass cls) throws NotFoundException {
        CtConstructor[] constructors = cls.getDeclaredConstructors();
        if (constructors.length == 0) {
            return true;
        }
        for (CtConstructor ctConstructor : constructors) {
            int modifiers = ctConstructor.getModifiers();
            if (Modifier.isPackage((int)modifiers) || Modifier.isPrivate((int)modifiers)) continue;
            return true;
        }
        return false;
    }

    private String getReturnCode(CtClass returnType) {
        if (returnType.equals(CtClass.voidType)) {
            return "{}";
        }
        return "{return " + TypeUtils.getDefaultValueAsString((String)returnType.getName()) + ";}";
    }

    private <T> String generateClassName(Class<T> clazz) {
        return "subclass." + clazz.getName() + "$$PowerMock" + counter.getAndIncrement();
    }
}

