package be.ehealth.businessconnector.test.hub.session;


import be.ehealth.businessconnector.hub.session.HubServiceComplete;
import be.ehealth.businessconnector.hub.session.HubSessionServiceFactory;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleProxy;
import be.fgov.ehealth.technicalconnector.tests.utils.TestPropertiesLoader;
import org.junit.rules.ExternalResource;

/**
 * @author EHP
 */
public class InitHubRule extends ExternalResource {

    private HubServiceComplete hubServiceComplete;

    @Override
    protected void before() throws Throwable {
        new ConfigurationModuleProxy().init(ConfigFactory.getConfigValidator().getConfig());
        HubTestHelper.initHub(HubConfig.CHOSENHUB_ID, TestPropertiesLoader.getProperties("/be.ehealth.businessconnector.intrahub.test.properties"));
        hubServiceComplete = HubSessionServiceFactory.getHubServiceComplete();
    }

    public HubServiceComplete getHubServiceComplete() {
        return hubServiceComplete;
    }

}
