/*
 * Copyright (c) eHealth
 */
package be.ehealth.business.test.kmehrcommons.builders;

import be.ehealth.business.kmehrcommons.builders.Id;
import org.junit.Assert;
import org.junit.Test;

import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTY;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;


/**
 * @author EH076
 *
 */
public class IdTest {

    @Test
    public void testId() {
        IDHCPARTY result = new Id().s(IDHCPARTYschemes.INSS).sl("sl").sv("1.0").value("77013014990").build();
        Assert.assertEquals(IDHCPARTYschemes.INSS, result.getS());
        Assert.assertEquals("sl", result.getSL());
        Assert.assertEquals("1.0", result.getSV());
        Assert.assertEquals("77013014990", result.getValue());
    }

    @Test
    public void testIdNoSv() {
        try {
            new Id().s(IDHCPARTYschemes.INSS).value("77013014990").build();
        } catch (IllegalArgumentException e) {
            Assert.assertEquals("sv may not be null!", e.getMessage());
        }
    }

    @Test
    public void testIdLocalWithoutS() {
        try {
            new Id().s(IDHCPARTYschemes.LOCAL).sv("1.0").value("77013014990").build();
        } catch (IllegalArgumentException e) {
            Assert.assertEquals("sl may not be null when s==local", e.getMessage());
        }
    }

}
