/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.KEKRecipientInformation;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UnsealUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsealUtils.class);

    private UnsealUtils() {
    }

    public static String getKekID(byte[] sealedData) {
        List<String> base64encodedKekIds = UnsealUtils.getKekIDs(sealedData);
        if (base64encodedKekIds.size() > 1) {
            throw new IllegalArgumentException("According to eHealth Policy, sealed messages may have 0 or 1 KEKRecipientInfos but this one contains more.");
        }
        return base64encodedKekIds.isEmpty() ? null : base64encodedKekIds.get(0);
    }

    public static String getSubjectKeyIdentifier(byte[] sealedData) {
        List<String> base64encodedSubjectKeyIds = UnsealUtils.getSubjectKeyIdentifiers(sealedData);
        if (base64encodedSubjectKeyIds.size() > 1) {
            throw new IllegalArgumentException("According to eHealth Policy, sealed messages must have 0 or 1 SubjectKeyIdentifier but this one contains more.");
        }
        return base64encodedSubjectKeyIds.isEmpty() ? null : base64encodedSubjectKeyIds.get(0);
    }

    static List<String> getKekIDs(byte[] sealedData) {
        ArrayList<String> base64encodedKekIds = new ArrayList<String>();
        byte[] signedData = UnsealUtils.getSignedContent(sealedData);
        List<KEKRecipientInformation> kekRecipientInfos = UnsealUtils.getKekRecipientInfos(signedData);
        for (KEKRecipientInformation kekRecipientInfo : kekRecipientInfos) {
            base64encodedKekIds.add(UnsealUtils.getBase64EncodedKekId((RecipientInformation)kekRecipientInfo));
        }
        return base64encodedKekIds;
    }

    static List<String> getSubjectKeyIdentifiers(byte[] sealedData) {
        ArrayList<String> base64encodedSubjectKeyIds = new ArrayList<String>();
        try {
            CMSSignedData cmsSignedData = new CMSSignedData(sealedData);
            for (SignerInformation si : cmsSignedData.getSignerInfos().getSigners()) {
                if (si.getSID().getSubjectKeyIdentifier() == null) continue;
                base64encodedSubjectKeyIds.add(new String(Base64.encode((byte[])si.getSID().getSubjectKeyIdentifier()), StandardCharsets.UTF_8));
            }
        }
        catch (CMSException e) {
            throw new IllegalArgumentException("Invalid SignedData block. Unable to get signed content from it.", e);
        }
        return base64encodedSubjectKeyIds;
    }

    static byte[] getSignedContent(byte[] signedData) {
        byte[] encryptedData;
        try {
            CMSSignedData cmsSignedData = new CMSSignedData(signedData);
            CMSTypedData signedContent = cmsSignedData.getSignedContent();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            signedContent.write((OutputStream)baos);
            encryptedData = baos.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid SignedData block. Unable to get signed content from it.", e);
        }
        return encryptedData;
    }

    static List<KEKRecipientInformation> getKekRecipientInfos(byte[] envelopedData) {
        ArrayList<KEKRecipientInformation> kekRecipientInfos = new ArrayList<KEKRecipientInformation>();
        Collection<RecipientInformation> recipientInfos = UnsealUtils.getRecipientInfos(envelopedData);
        for (RecipientInformation recipientInfo : recipientInfos) {
            if (!(recipientInfo instanceof KEKRecipientInformation)) continue;
            kekRecipientInfos.add((KEKRecipientInformation)recipientInfo);
            byte[] kekId = UnsealUtils.getKekId(recipientInfo);
            String base64encodedKekId = new String(Base64.encode((byte[])kekId));
            LOGGER.debug("Found KEKRecipientInfo with base64 encoded KEK ID : " + base64encodedKekId);
        }
        return kekRecipientInfos;
    }

    static Collection<RecipientInformation> getRecipientInfos(byte[] envelopedData) {
        Collection recipientInfos;
        try {
            CMSEnvelopedDataParser envelopedDataParser = new CMSEnvelopedDataParser(envelopedData);
            recipientInfos = envelopedDataParser.getRecipientInfos().getRecipients();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid EnvelopedData block. Unable to get recipient info from it.", e);
        }
        return recipientInfos;
    }

    static byte[] getKekId(RecipientInformation recipientInfo) {
        try {
            if (recipientInfo instanceof KEKRecipientInformation) {
                Field field = recipientInfo.getRID().getClass().getDeclaredField("keyIdentifier");
                field.setAccessible(true);
                return (byte[])field.get(recipientInfo.getRID());
            }
        }
        catch (Exception exception) {
            LOGGER.error("The KEK id could not be found", (Throwable)exception);
        }
        return new byte[0];
    }

    static String getBase64EncodedKekId(RecipientInformation recipientInfo) {
        return new String(Base64.encode((byte[])UnsealUtils.getKekId(recipientInfo)));
    }
}

