/**
 * Copyright (c) eHealth
 */
package be.ehealth.business.test.mycarenetcommons.v4.builders.impl;

import be.cin.encrypted.BusinessContent;
import be.ehealth.business.mycarenetcommons.domain.SignedResponseHolder;
import be.ehealth.business.mycarenetcommons.domain.SignedEncryptedResponseHolder;
import be.ehealth.business.mycarenetcommons.domain.EncryptedRequestHolder;
import be.ehealth.business.mycarenetcommons.v4.builders.ResponseObjectBuilderHelper;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.etee.Crypto;
import be.ehealth.technicalconnector.service.etee.domain.UnsealedData;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.messageservices.core.v1.SendTransactionResponse;
import be.fgov.ehealth.mycarenet.commons.core.v4.BlobType;
import be.fgov.ehealth.mycarenet.commons.protocol.v4.ResponseReturnType;
import be.fgov.ehealth.mycarenet.commons.protocol.v4.SendRequestType;
import be.fgov.ehealth.mycarenet.commons.protocol.v4.SendResponseType;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationError;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.w3._2005._05.xmlmime.Base64Binary;

import java.io.ByteArrayInputStream;

/**
 * Test for class ResponseObjectBuilderHelper
 *
 * @author EHP
 */
@RunWith(PowerMockRunner.class)
@PrepareForTest({ConnectorXmlUtils.class, SessionUtil.class})
public class ResponseObjectBuilderImplTest {

    @Test
    public void buildWithMissingEncryptedSignature() throws Exception {
        SendResponseType sendResponseType = new SendResponseType();
        ResponseReturnType ret = new ResponseReturnType();
        BlobType blob = buildBlobType();
        ret.setDetail(blob);
        sendResponseType.setReturn(ret);
        ResponseObjectBuilderHelper responseObjectBuilder = new ResponseObjectBuilderHelper();
        PowerMock.mockStatic(ConnectorXmlUtils.class);
        PowerMock.mockStatic(SessionUtil.class);
        Crypto crypto = PowerMock.createMock(Crypto.class);
        Class<SendTransactionResponse> clazz = SendTransactionResponse.class;
        UnsealedData data = new UnsealedData();
        data.setContent(new ByteArrayInputStream("<EncryptedKnownContent><BusinessContent></BusinessContent></EncryptedKnownContent>".getBytes()));
        EasyMock.expect(crypto.unseal(EasyMock.anyObject(Crypto.SigningPolicySelector.class), EasyMock.anyObject(byte[].class))).andReturn(data);
        EasyMock.expect(SessionUtil.getHolderOfKeyCrypto()).andReturn(crypto);
        EasyMock.expect(ConnectorXmlUtils.toObject(EasyMock.anyObject(byte[].class), EasyMock.anyObject(clazz.getClass()))).andReturn(new SendTransactionResponse());
        EasyMock.expectLastCall();
        PowerMock.replayAll();

        SignedEncryptedResponseHolder encryptedResponse = responseObjectBuilder.build(sendResponseType, new EncryptedRequestHolder(null, new BusinessContent()));

        Assert.assertNotNull(encryptedResponse);
        Assert.assertNotNull(encryptedResponse);
        Assert.assertFalse(encryptedResponse.getSignatureVerificationResult().getErrors().isEmpty());
        Assert.assertTrue(encryptedResponse.getSignatureVerificationResult().getErrors().contains(SignatureVerificationError.SIGNATURE_NOT_PRESENT));
    }


    @Test
    public void buildWithMissingXadesValue() throws TechnicalConnectorException {
        SendResponseType sendResponseType = new SendResponseType();
        ResponseReturnType responseReturnType = new ResponseReturnType();
        BlobType blob = buildBlobType();
        PowerMock.mockStatic(ConnectorXmlUtils.class);
        responseReturnType.setDetail(blob);
        Base64Binary xades = new Base64Binary();
        xades.setValue(null);
        responseReturnType.setXadesT(xades);
        sendResponseType.setReturn(responseReturnType);
        ResponseObjectBuilderHelper responseObjectBuilder = new ResponseObjectBuilderHelper();
        Class<SendTransactionResponse> clazz = SendTransactionResponse.class;
        EasyMock.expect(ConnectorXmlUtils.toObject(EasyMock.anyObject(byte[].class), EasyMock.anyObject(clazz.getClass()))).andReturn(new SendTransactionResponse());
        EasyMock.expectLastCall();
        PowerMock.replayAll();

        SignedResponseHolder signedResponse = responseObjectBuilder.build(sendResponseType, new SendRequestType());

        Assert.assertNotNull(signedResponse);
        Assert.assertFalse(signedResponse.getSignatureVerificationResult().getErrors().isEmpty());
        Assert.assertTrue(signedResponse.getSignatureVerificationResult().getErrors().contains(SignatureVerificationError.SIGNATURE_NOT_PRESENT));
    }

    @Test
    public void buildWithMissingXades() throws TechnicalConnectorException {
        SendResponseType sendResponseType = new SendResponseType();
        ResponseReturnType responseReturnType = new ResponseReturnType();
        BlobType blob = buildBlobType();
        PowerMock.mockStatic(ConnectorXmlUtils.class);
        responseReturnType.setDetail(blob);
        sendResponseType.setReturn(responseReturnType);
        ResponseObjectBuilderHelper responseObjectBuilder = new ResponseObjectBuilderHelper();
        Class<SendTransactionResponse> clazz = SendTransactionResponse.class;
        EasyMock.expect(ConnectorXmlUtils.toObject(EasyMock.anyObject(byte[].class), EasyMock.anyObject(clazz.getClass()))).andReturn(new SendTransactionResponse());
        EasyMock.expectLastCall();
        PowerMock.replayAll();

        SignedResponseHolder signedResponse = responseObjectBuilder.build(sendResponseType, new SendRequestType());

        Assert.assertNotNull(signedResponse);
        Assert.assertFalse(signedResponse.getSignatureVerificationResult().getErrors().isEmpty());
        Assert.assertTrue(signedResponse.getSignatureVerificationResult().getErrors().contains(SignatureVerificationError.SIGNATURE_NOT_PRESENT));
    }


    private BlobType buildBlobType() {
        BlobType blob = new BlobType();
        blob.setContentEncoding("none");
        blob.setContentType("text/xml");
        blob.setId("RSP-a41bba3d-88a6-491f-9063-865d082e6442");
        blob.setValue("<SendTransactionResponse></SendTransactionResponse>".getBytes());
        return blob;
    }
}
