/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.enumeration.MimeType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.commons.lang3.ArrayUtils;

public class ByteArrayDatasource
implements DataSource {
    private byte[] byteArray;
    private String contentType = DEFAULT_CONTENT_TYPE;
    protected static final String DEFAULT_CONTENT_TYPE = MimeType.OCTECT_STREAM.getValue();

    public ByteArrayDatasource(byte[] byteArray) {
        this.byteArray = ArrayUtils.clone((byte[])byteArray);
        this.contentType = DEFAULT_CONTENT_TYPE;
    }

    public ByteArrayDatasource(byte[] byteArray, String contentType) {
        this.byteArray = ArrayUtils.clone((byte[])byteArray);
        this.contentType = contentType;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.byteArray);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("This is a read-only datasource");
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        throw new UnsupportedOperationException("This is a read-only datasource");
    }

    public byte[] getByteArray() {
        return ArrayUtils.clone((byte[])this.byteArray);
    }
}

