﻿using be.ehealth.businessconnector.mycarenet.agreementv2.builders;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.errors.core.v1;
using be.fgov.ehealth.errors.soa.v1;
using javax.xml.soap;
using javax.xml.ws.soap;
using NUnit.Framework;

namespace be.ehealth.businessconnector.mycarenet.agreementv2.session
{

	[TestFixture]
	public class AgreementLogopedistIntegrationTest : AbstractBaseIntegrationTest {
	
	    private static readonly string REQ_DIR = ".\\examples\\mycarenet\\eagreementv2\\requests\\";
	
	    private static readonly string LAST_PART_REQ_LOCATION = "RequestContent.xml";
	    
	    [SetUp]
	    public void init() {
	    	java.util.Properties props = new java.util.Properties();			
        	props.put("session.environment", "acc");
            props.put("session.professionType", "persphysiotherapist");
            props.put("session.username", "maxime");
			SessionInitializer.init(props, true, SupportedLanguages.NET.getAbbreviation());
	    }
	    
	    [TearDown]
		public void tearDown() {
			SessionDestroyer.destroy();
		}
	
	    [Test]
	    public void askAgreementWithEncryption() {
	        askAgreementTest("01-KIN-EMEHS", REQ_DIR + "Agreement" + LAST_PART_REQ_LOCATION);
	    }

	    [Test]
	    public void consultAgreementWithEncryption() {
	        consultAgreementTest("01-KIN-EMEHS", REQ_DIR + "Agreement" + LAST_PART_REQ_LOCATION);
	    }
	    
	    [Test]
        public void unhappyAskAgreementWithEncryption() {
            try {
                askAgreementTest("02-KIN-ENXS", REQ_DIR + "UnhappyAskAgreement" + LAST_PART_REQ_LOCATION);
                Assert.Fail("soap fault expected");
            } catch (SOAPFaultException sfe) {
                checkSOAPFault(sfe);
            }
        }
	}
}
