/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.mycarenet.agreementv2.session;

import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

import javax.xml.ws.soap.SOAPFaultException;

/**
 * *
 * @author EHP
 */
public class AgreementPhysiotherapistIntegrationTest extends AbstractBaseIntegrationTest {

    private static final String REQ_DIR = "/examples/mycarenet/eagreementv2/requests/";

    private static final String LAST_PART_REQ_LOCATION = "RequestContent.xml";

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysiotherapist").forUser("maxime").build();


    @Test
    public void askAgreementWithEncryption() throws Exception {
        askAgreementTest("01-KIN-EMEHS", REQ_DIR + "Agreement" + LAST_PART_REQ_LOCATION);
    }

    @Test
    public void consultAgreementWithEncryption() throws Exception {
        consultAgreementTest("01-KIN-EMEHS", REQ_DIR + "Agreement" + LAST_PART_REQ_LOCATION);
    }

    @Test
    public void unhappyAskAgreementWithEncryption() throws Exception {
        try {
            askAgreementTest("02-KIN-ENXS",REQ_DIR + "UnhappyAskAgreement" + LAST_PART_REQ_LOCATION);
            Assert.fail("soap fault expected");
        } catch (SOAPFaultException sfe) {
            checkSOAPFault(sfe);
        }
    }
}
