package be.ehealth.businessconnector.test.mycarenet.agreementv2.session;

import be.ehealth.business.mycarenetcommons.domain.EncryptedRequestHolder;
import be.ehealth.business.mycarenetcommons.domain.SignedEncryptedResponseHolder;
import be.ehealth.business.mycarenetdomaincommons.domain.Attribute;
import be.ehealth.business.mycarenetdomaincommons.domain.InputReference;
import be.ehealth.business.mycarenetdomaincommons.domain.Ssin;
import be.ehealth.businessconnector.mycarenet.agreementv2.builders.AgreementRequestInput;
import be.ehealth.businessconnector.mycarenet.agreementv2.builders.ResponseObjectBuilder;
import be.ehealth.businessconnector.mycarenet.agreementv2.builders.ResponseObjectBuilderFactory;
import be.ehealth.businessconnector.mycarenet.agreementv2.session.AgreementService;
import be.ehealth.businessconnector.mycarenet.agreementv2.session.AgreementSessionServiceFactory;
import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.errors.core.v1.LocalisedStringType;
import be.fgov.ehealth.errors.soa.v1.BusinessError;
import be.fgov.ehealth.mycarenet.agreement.protocol.v2.AskAgreementRequest;
import be.fgov.ehealth.mycarenet.agreement.protocol.v2.AskAgreementResponse;
import be.fgov.ehealth.mycarenet.agreement.protocol.v2.ConsultAgreementRequest;
import be.fgov.ehealth.mycarenet.agreement.protocol.v2.ConsultAgreementResponse;
import be.fgov.ehealth.technicalconnector.tests.utils.XmlAsserter;
import org.joda.time.LocalDateTime;
import org.junit.Assert;

import javax.xml.soap.DetailEntry;
import javax.xml.ws.soap.SOAPFaultException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import static be.ehealth.businessconnector.mycarenet.agreementv2.builders.RequestObjectBuilderFactory.getEncryptedRequestObjectBuilder;
import static be.ehealth.technicalconnector.enumeration.Charset.UTF_8;

public abstract class AbstractBaseIntegrationTest {

    protected void askAgreementTest(String inputReference, String bundleLocation) throws Exception {
        AgreementService service = AgreementSessionServiceFactory.getAgreementService();
        ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();
        byte[] bundle = ConnectorIOUtils.getResourceAsString(bundleLocation).getBytes(UTF_8.getName());
        ConnectorXmlUtils.dump(bundle);

        // input reference and AttributeQuery ID must match
        EncryptedRequestHolder<AskAgreementRequest> requestBuilder = getEncryptedRequestObjectBuilder().buildAskAgreementRequest(
                AgreementRequestInput.builder()
                        .isTest(true)
                        .inputReference(new InputReference(inputReference))
                        .fhirMessage(bundle)
                        .patientSsin(new Ssin("72070539942"))
                        .referenceDate(LocalDateTime.now())
                        .messageVersion("2.0")
                        .issuer("some issuer")
                        .commonInputAttributes(Arrays.asList(Attribute.builder()
                                        .key("urn:be:cin:nippin:purpose")
                                        .value("some purpose")
                                        .build(),
                                Attribute.builder()
                                        .key("urn:be:cin:nippin:attemptNbr")
                                        .value(1)
                                        .build()))
                        .build());

        AskAgreementResponse response = service.askAgreement(requestBuilder.getRequest());

        assertResponse(responseBuilder.handleAskAgreementResponse(response, requestBuilder));
    }

    protected void consultAgreementTest(String inputReference, String bundleLocation) throws Exception {
        AgreementService service = AgreementSessionServiceFactory.getAgreementService();
        ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();
        byte[] bundle = ConnectorIOUtils.getResourceAsString(bundleLocation).getBytes(UTF_8.getName());
        ConnectorXmlUtils.dump(bundle);

        // input reference and AttributeQuery ID must match
        EncryptedRequestHolder<ConsultAgreementRequest> requestBuilder = getEncryptedRequestObjectBuilder().buildConsultAgreementRequest(
                AgreementRequestInput.builder()
                        .isTest(true)
                        .inputReference(new InputReference(inputReference))
                        .fhirMessage(bundle)
                        .patientSsin(new Ssin("86081523513"))
                        .referenceDate(LocalDateTime.now())
                        .messageVersion("2.0")
                        .issuer("some issuer")
                        .commonInputAttributes(Arrays.asList(Attribute.builder()
                                        .key("urn:be:cin:nippin:purpose")
                                        .value("some purpose")
                                        .build(),
                                Attribute.builder()
                                        .key("urn:be:cin:nippin:attemptNbr")
                                        .value(1)
                                        .build()))
                        .build());

        ConsultAgreementResponse response = service.consultAgreement(requestBuilder.getRequest());

        SignedEncryptedResponseHolder encryptedResponseHolder = responseBuilder.handleConsultAgreementResponse(response, requestBuilder);
        Assert.assertNotNull(encryptedResponseHolder.getSignedData());
        Assert.assertNotNull(encryptedResponseHolder.getRawDecryptedBlob());
    }
    
    protected void checkSOAPFault(SOAPFaultException sfe) {
        List<DetailEntry> entries = new ArrayList<DetailEntry>();
        Iterator it = sfe.getFault().getDetail().getDetailEntries();
        while (it.hasNext()) entries.add((DetailEntry) it.next());

        Assert.assertEquals(1, entries.size());

        MarshallerHelper<BusinessError, BusinessError> helper = new MarshallerHelper<BusinessError, BusinessError>(BusinessError.class, BusinessError.class);
        BusinessError error = helper.toObject(entries.get(0));

        Assert.assertEquals("EMPTY_BLOB", error.getCode());
        Assert.assertEquals("MYCARENET", error.getOrigin());

        List<LocalisedStringType> messages = error.getMessages();
        Assert.assertEquals(1, messages.size());

        LocalisedStringType message = messages.get(0);
        Assert.assertEquals("Blob is empty.", message.getValue());
    }
    
    private void assertResponse(SignedEncryptedResponseHolder response) throws UnsupportedEncodingException, TechnicalConnectorException {
        Assert.assertTrue("Errors found in the signature verification", response.getSignatureVerificationResult().isValid());
        Assert.assertNotNull(response.getXadesT());
        Assert.assertNotNull(response.getSignedData());
        Assert.assertNotNull(response.getRawDecryptedBlob());
        String expectedResponse = ConnectorIOUtils.getResourceAsString("/examples/mycarenet/eagreementv2/responses/mh-response-detail.xml");
        XmlAsserter.assertSimilar(expectedResponse, new String(response.getBusinessResponse(), Charset.UTF_8.getName()));
   }
}
