package be.ehealth.business.test.mycarenetcommons.mappers.v4;

import be.ehealth.business.mycarenetcommons.v4.mapper.CommonInputMapper;
import be.ehealth.business.mycarenetdomaincommons.domain.Attribute;
import be.ehealth.business.mycarenetdomaincommons.domain.CareProvider;
import be.ehealth.business.mycarenetdomaincommons.domain.CommonInput;
import be.ehealth.business.mycarenetdomaincommons.domain.Identification;
import be.ehealth.business.mycarenetdomaincommons.domain.Nihii;
import be.ehealth.business.mycarenetdomaincommons.domain.Origin;
import be.ehealth.business.mycarenetdomaincommons.domain.Party;
import be.ehealth.business.mycarenetdomaincommons.domain.Reference;
import be.ehealth.technicalconnector.config.util.domain.PackageInfo;
import be.fgov.ehealth.mycarenet.commons.core.v4.CommonInputType;
import org.junit.Assert;
import org.junit.Test;
import org.mapstruct.factory.Mappers;

import java.util.Arrays;

public class CommonInputMapperTest {

    @Test
    public void mapCommontInput() {
        Identification identification = new Identification();

        String name = "dummy_name";
        identification.setName(name);

        String ssin = "dummy_ssin";
        identification.setSsin(ssin);

        String cbe = "dummy_cbe";
        identification.setCbe(cbe);

        String nihiiValue = "10013368001";
        String quality = "persphysician";
        Nihii nihii = new Nihii(quality, nihiiValue);
        identification.setNihii(nihii);

        Party party = new Party();
        party.setPhysicalPerson(identification);
        party.setOrganization(identification);

        String packageName = "dummy_name";
        String packageUsername = "dummy_username";
        String packagePassword = "dummy_password";
        PackageInfo packageInfo = new PackageInfo(packageUsername, packagePassword, packageName);

        CareProvider careProvider = new CareProvider(nihii);
        Origin origin = new Origin(packageInfo, careProvider);

        origin.setSender(party);
        String siteId = "dummy_siteId";
        origin.setSiteId(siteId);

        String inputReference = "dummy_inputreference";
        CommonInput commonInput = new CommonInput(true, origin, inputReference,
                Arrays.asList(Reference.builder()
                        .type("type1")
                        .value("value1")
                        .build(), Reference.builder()
                        .type("type2")
                        .value("value2")
                        .build()),
                Arrays.asList(Attribute.builder()
                        .key("key1")
                        .value("value1")
                        .build(), Attribute.builder()
                        .key("key2")
                        .value("value2")
                        .build()));

        CommonInputMapper mapper = Mappers.getMapper(CommonInputMapper.class);
        CommonInputType result = mapper.map(commonInput);

        Assert.assertTrue(result.getRequest().isIsTest());
        Assert.assertEquals(result.getRequest().isIsTest(), commonInput.isTest());

        Assert.assertEquals(inputReference, result.getInputReference());
        Assert.assertEquals(result.getInputReference(), commonInput.getInputReference());

        Assert.assertEquals(packageName, result.getOrigin().getPackage().getName().getValue());
        Assert.assertEquals(result.getOrigin().getPackage().getName().getValue(), packageInfo.getPackageName());

        Assert.assertEquals(packageUsername, result.getOrigin().getPackage().getLicense().getUsername());
        Assert.assertEquals(result.getOrigin().getPackage().getLicense().getUsername(), packageInfo.getUserName());

        Assert.assertEquals(packagePassword, result.getOrigin().getPackage().getLicense().getPassword());
        Assert.assertEquals(result.getOrigin().getPackage().getLicense().getPassword(), packageInfo.getPassword());

        Assert.assertEquals(siteId, result.getOrigin().getSiteID().getValue());
        Assert.assertEquals(result.getOrigin().getSiteID().getValue(), origin.getSiteId());

        Assert.assertEquals(name, result.getOrigin().getSender().getPhysicalPerson().getName().getValue());
        Assert.assertEquals(result.getOrigin().getSender().getPhysicalPerson().getName().getValue(), party.getPhysicalPerson().getName());

        Assert.assertEquals(ssin, result.getOrigin().getSender().getPhysicalPerson().getSsin().getValue());
        Assert.assertEquals(result.getOrigin().getSender().getPhysicalPerson().getSsin().getValue(), party.getPhysicalPerson().getSsin());

        Assert.assertEquals(nihiiValue, result.getOrigin().getSender().getPhysicalPerson().getNihii().getValue().getValue());
        Assert.assertEquals(result.getOrigin().getSender().getPhysicalPerson().getNihii().getValue().getValue(), party.getPhysicalPerson().getNihii().getValue());

        Assert.assertEquals(quality, result.getOrigin().getSender().getPhysicalPerson().getNihii().getQuality());
        Assert.assertEquals(result.getOrigin().getSender().getPhysicalPerson().getNihii().getQuality(), party.getPhysicalPerson().getNihii().getQuality());

        Assert.assertEquals(cbe, result.getOrigin().getSender().getPhysicalPerson().getCbe().getValue());
        Assert.assertEquals(result.getOrigin().getSender().getPhysicalPerson().getCbe().getValue(), party.getPhysicalPerson().getCbe());

        Assert.assertEquals(quality, result.getOrigin().getCareProvider().getNihii().getQuality());
        Assert.assertEquals(result.getOrigin().getCareProvider().getNihii().getQuality(), origin.getCareProvider().getNihii().getQuality());

        Assert.assertEquals(nihiiValue, result.getOrigin().getCareProvider().getNihii().getValue().getValue());
        Assert.assertEquals(result.getOrigin().getCareProvider().getNihii().getValue().getValue(), origin.getCareProvider().getNihii().getValue());
        
        Assert.assertEquals(2, result.getReferences().size());
        Assert.assertEquals("type1", result.getReferences().get(0).getType());
        Assert.assertEquals("value1", result.getReferences().get(0).getValue());
        Assert.assertEquals("type2", result.getReferences().get(1).getType());
        Assert.assertEquals("value2", result.getReferences().get(1).getValue());
        Assert.assertEquals(2, result.getAttributes().size());
        Assert.assertEquals("key1", result.getAttributes().get(0).getKey());
        Assert.assertEquals("value1", result.getAttributes().get(0).getValue());
        Assert.assertEquals("key2", result.getAttributes().get(1).getKey());
        Assert.assertEquals("value2", result.getAttributes().get(1).getValue());
    }


    @Test
    public void mapNullValueToNullValueRefString() {
        Identification identification = new Identification();

        String nihiiValue = "10013368001";
        String quality = "persphysician";
        Nihii nihii = new Nihii(quality, null);
        identification.setNihii(nihii);

        Party party = new Party();
        party.setPhysicalPerson(identification);
        party.setOrganization(identification);

        String packageUsername = "dummy_username";
        String packagePassword = "dummy_password";
        PackageInfo packageInfo = new PackageInfo(packageUsername, packagePassword, null);

        CareProvider careProvider = new CareProvider(nihii);
        Origin origin = new Origin(packageInfo, careProvider);

        origin.setSender(party);

        String inputReference = "dummy_inputreference";
        CommonInput commonInput = new CommonInput(true, origin, inputReference,
                Arrays.asList(Reference.builder()
                        .type("type1")
                        .value("value1")
                        .build(), Reference.builder()
                        .type("type2")
                        .value("value2")
                        .build()),
                Arrays.asList(Attribute.builder()
                        .key("key1")
                        .value("value1")
                        .build(), Attribute.builder()
                        .key("key2")
                        .value("value2")
                        .build()));

        CommonInputMapper mapper = Mappers.getMapper(CommonInputMapper.class);
        CommonInputType result = mapper.map(commonInput);

        Assert.assertTrue(result.getRequest().isIsTest());
        Assert.assertEquals(result.getRequest().isIsTest(), commonInput.isTest());

        Assert.assertEquals(inputReference, result.getInputReference());
        Assert.assertEquals(result.getInputReference(), commonInput.getInputReference());

        Assert.assertNull(result.getOrigin().getPackage().getName());

        Assert.assertEquals(packageUsername, result.getOrigin().getPackage().getLicense().getUsername());
        Assert.assertEquals(result.getOrigin().getPackage().getLicense().getUsername(), packageInfo.getUserName());

        Assert.assertEquals(packagePassword, result.getOrigin().getPackage().getLicense().getPassword());
        Assert.assertEquals(result.getOrigin().getPackage().getLicense().getPassword(), packageInfo.getPassword());

        Assert.assertNull(result.getOrigin().getSiteID());

        Assert.assertNull(result.getOrigin().getSender().getPhysicalPerson().getName());

        Assert.assertNull(result.getOrigin().getSender().getPhysicalPerson().getSsin());

        Assert.assertNull(result.getOrigin().getSender().getPhysicalPerson().getNihii().getValue());

        Assert.assertEquals(quality, result.getOrigin().getSender().getPhysicalPerson().getNihii().getQuality());
        Assert.assertEquals(result.getOrigin().getSender().getPhysicalPerson().getNihii().getQuality(), party.getPhysicalPerson().getNihii().getQuality());

        Assert.assertNull(result.getOrigin().getSender().getPhysicalPerson().getCbe());

        Assert.assertEquals(quality, result.getOrigin().getCareProvider().getNihii().getQuality());
        Assert.assertEquals(result.getOrigin().getCareProvider().getNihii().getQuality(), origin.getCareProvider().getNihii().getQuality());

        Assert.assertNull(nihiiValue, result.getOrigin().getCareProvider().getNihii().getValue());

        Assert.assertEquals(2, result.getReferences().size());
        Assert.assertEquals("type1", result.getReferences().get(0).getType());
        Assert.assertEquals("value1", result.getReferences().get(0).getValue());
        Assert.assertEquals("type2", result.getReferences().get(1).getType());
        Assert.assertEquals("value2", result.getReferences().get(1).getValue());
        Assert.assertEquals(2, result.getAttributes().size());
        Assert.assertEquals("key1", result.getAttributes().get(0).getKey());
        Assert.assertEquals("value1", result.getAttributes().get(0).getValue());
        Assert.assertEquals("key2", result.getAttributes().get(1).getKey());
        Assert.assertEquals("value2", result.getAttributes().get(1).getValue());
    }
}
