/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.signature;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConfigurableFactoryHelper;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilder;
import be.fgov.ehealth.technicalconnector.signature.impl.CmsSignatureBuilder;
import be.fgov.ehealth.technicalconnector.signature.impl.XmlSignatureBuilder;
import be.fgov.ehealth.technicalconnector.signature.impl.xades.impl.XadesBesSpecification;
import be.fgov.ehealth.technicalconnector.signature.impl.xades.impl.XadesSpecification;
import be.fgov.ehealth.technicalconnector.signature.impl.xades.impl.XadesTSpecification;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignatureBuilderFactory {
    private static final String PROP_SIGNATUREBUILDER_CLASS = "signature.signaturebuilder.class";
    private static final Logger LOG = LoggerFactory.getLogger(SignatureBuilderFactory.class);
    private static Map<AdvancedElectronicSignatureEnumeration, SignatureBuilder> builders = new EnumMap<AdvancedElectronicSignatureEnumeration, SignatureBuilder>(AdvancedElectronicSignatureEnumeration.class);

    private SignatureBuilderFactory() {
        throw new UnsupportedOperationException();
    }

    private static void processBuilder(SignatureBuilder builder) {
        if (!builders.containsKey((Object)builder.getSupportedAES())) {
            LOG.debug("Adding builder for AES: " + (Object)((Object)builder.getSupportedAES()) + " [" + builder.getClass() + "]");
            builders.put(builder.getSupportedAES(), builder);
        } else {
            LOG.warn("Ignoring builder with AES : " + (Object)((Object)builder.getSupportedAES()) + " [" + builder.getClass() + "]. Reason: AES already instantiated. [" + builders.get((Object)builder.getSupportedAES()).getClass() + "]");
        }
    }

    public static SignatureBuilder getSignatureBuilder(AdvancedElectronicSignatureEnumeration instance) throws TechnicalConnectorException {
        if (builders.containsKey((Object)instance)) {
            return builders.get((Object)instance);
        }
        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, new Object[]{"Unsupported AdvancedElectricignature: " + (Object)((Object)instance)});
    }

    static {
        ConfigurableFactoryHelper configHelper = new ConfigurableFactoryHelper(PROP_SIGNATUREBUILDER_CLASS, null);
        try {
            List builderList = configHelper.getImplementations();
            if (builderList.isEmpty()) {
                LOG.warn("No Signature Builders configured reason: no valid config. Instantiating with default builders");
                SignatureBuilderFactory.processBuilder(new XmlSignatureBuilder(AdvancedElectronicSignatureEnumeration.XML, new be.fgov.ehealth.technicalconnector.signature.impl.xades.XadesSpecification[0]));
                SignatureBuilderFactory.processBuilder(new XmlSignatureBuilder(AdvancedElectronicSignatureEnumeration.XAdES, new XadesSpecification(), new XadesBesSpecification()));
                SignatureBuilderFactory.processBuilder(new XmlSignatureBuilder(AdvancedElectronicSignatureEnumeration.XAdES_T, new XadesSpecification(), new XadesTSpecification()));
                SignatureBuilderFactory.processBuilder(new CmsSignatureBuilder(AdvancedElectronicSignatureEnumeration.CAdES));
            }
            for (SignatureBuilder builder : builderList) {
                SignatureBuilderFactory.processBuilder(builder);
            }
        }
        catch (TechnicalConnectorException e) {
            LOG.warn("No Signature Builders configured reason:" + e.getMessage(), (Throwable)e);
        }
    }
}

