/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.handler.AbstractSOAPHandler;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionTimeOutHandler
extends AbstractSOAPHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionTimeOutHandler.class);
    private static final String REQUEST_TIMEOUT = "com.sun.xml.internal.ws.request.timeout";
    private static final String CONNECT_TIMEOUT = "com.sun.xml.internal.ws.connect.timeout";
    public static final String REQUEST_TIMEOUT_PROP = "connector.soaphandler.connection.request.timeout";
    public static final String CONNECT_TIMEOUT_PROP = "connector.soaphandler.connection.connection.timeout";
    private Configuration config = ConfigFactory.getConfigValidator();
    private static final String DEFAULT_TIME_OUT = "30000";

    @Override
    public boolean handleOutbound(SOAPMessageContext context) {
        String requestTimeOut = this.getDuration(REQUEST_TIMEOUT_PROP);
        LOG.debug("Setting request timeout on: {} milliseconds.", (Object)requestTimeOut);
        context.put((Object)REQUEST_TIMEOUT, (Object)requestTimeOut);
        context.put((Object)REQUEST_TIMEOUT_PROP, (Object)requestTimeOut);
        String connectTimeOut = this.getDuration(CONNECT_TIMEOUT_PROP);
        LOG.debug("Setting connect timeout on: {} milliseconds.", (Object)connectTimeOut);
        context.put((Object)CONNECT_TIMEOUT, (Object)connectTimeOut);
        context.put((Object)CONNECT_TIMEOUT_PROP, (Object)connectTimeOut);
        return true;
    }

    private String getDuration(String requestTimeoutProp) {
        if (this.config.hasDurationProperty(requestTimeoutProp)) {
            return Long.toString(this.config.getDurationProperty(REQUEST_TIMEOUT_PROP, 30L, TimeUnit.SECONDS).convert(TimeUnit.MILLISECONDS));
        }
        return this.config.getProperty(requestTimeoutProp, DEFAULT_TIME_OUT);
    }

    @Override
    public boolean handleFault(SOAPMessageContext context) {
        return this.handleMessage(context);
    }
}

