/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.idgenerator;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.idgenerator.IdGenerator;
import be.ehealth.technicalconnector.idgenerator.impl.DateTimeIdGenerator;
import be.ehealth.technicalconnector.idgenerator.impl.NanoTimeGenerator;
import be.ehealth.technicalconnector.idgenerator.impl.TimeBasedUniqueKeyGenerator;
import be.ehealth.technicalconnector.idgenerator.impl.UUIDGenerator;
import be.ehealth.technicalconnector.idgenerator.impl.XSIDGenerator;
import be.ehealth.technicalconnector.utils.ConfigurableFactoryHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdGeneratorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(IdGeneratorFactory.class);
    public static final String PROPS_IDGENERATOR_PREFIX = "be.ehealth.technicalconnector.idgenerator.";
    public static final String PROPS_IDGENERATOR_SUFFIX = ".classname";
    public static final String DEFAULT = "default";
    public static final String UUID = "uuid";
    public static final String XSID = "xsid";
    public static final String TIMEBASED = "time";
    public static final String NANO = "nano";
    private static final String DEFAULT_INPUT_REF_GENERATOR_CHECKER_CLASS = DateTimeIdGenerator.class.getName();
    private static Map<String, IdGenerator> cachedInstance = new HashMap<String, IdGenerator>();
    private static Map<String, String> defaultGeneratorClasses = new HashMap<String, String>();

    private IdGeneratorFactory() {
    }

    public static IdGenerator getIdGenerator() throws TechnicalConnectorException {
        return IdGeneratorFactory.getIdGenerator(DEFAULT);
    }

    public static IdGenerator getIdGenerator(String type) throws TechnicalConnectorException {
        if (!cachedInstance.containsKey(type)) {
            String defaultimpl = StringUtils.defaultString((String)defaultGeneratorClasses.get(type), (String)DEFAULT_INPUT_REF_GENERATOR_CHECKER_CLASS);
            ConfigurableFactoryHelper helper = new ConfigurableFactoryHelper(PROPS_IDGENERATOR_PREFIX + type + PROPS_IDGENERATOR_SUFFIX, defaultimpl);
            cachedInstance.put(type, (IdGenerator)helper.getImplementation());
        }
        return cachedInstance.get(type);
    }

    public static void invalidateCachedInstance() {
        cachedInstance.clear();
    }

    public static void registerDefaultImplementation(String type, Class<? extends IdGenerator> clazz) {
        if (defaultGeneratorClasses.containsKey(type)) {
            LOG.warn("Default implementation already exist for type [{}] with value [{}] replaced by  [{}]", new Object[]{type, defaultGeneratorClasses.get(type), clazz.getName()});
        }
        defaultGeneratorClasses.put(type, clazz.getName());
    }

    static {
        defaultGeneratorClasses.put(UUID, UUIDGenerator.class.getName());
        defaultGeneratorClasses.put(XSID, XSIDGenerator.class.getName());
        defaultGeneratorClasses.put(DEFAULT, DEFAULT_INPUT_REF_GENERATOR_CHECKER_CLASS);
        defaultGeneratorClasses.put(TIMEBASED, TimeBasedUniqueKeyGenerator.class.getName());
        defaultGeneratorClasses.put(NANO, NanoTimeGenerator.class.getName());
    }
}

