﻿using be.ehealth.businessconnector.mycarenet.agreement.builders;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.technicalconnector.utils;
using NUnit.Framework;

namespace be.ehealth.businessconnector.mycarenet.agreement.session
{

	[TestFixture]
	public class AgreementPhysiotherapistIntegrationTest : AbstractBaseIntegrationTest {
	
	    private static readonly string REQ_DIR = ".\\examples\\mycarenet\\eagreement\\requests\\";
	
	    private static readonly string LAST_PART_REQ_LOCATION = "RequestContent.xml";
	
	    public AgreementPhysiotherapistIntegrationTest() : base() {
	        
	    }
	    
	    [SetUp]
	    public void init() {
	    	java.util.Properties props = new java.util.Properties();			
        	props.put("session.environment", "acc");
            props.put("session.professionType", "persphysiotherapist");
            props.put("session.username", "hannes");
			SessionInitializer.init(props, true, SupportedLanguages.NET.getAbbreviation());
			setProfessionalNihii(SessionUtil.getNihii11());
	    }
	    
	    [TearDown]
		public void tearDown() {
			SessionDestroyer.destroy();
		}
	
	    [Test]
	    public void askAgreementWithEncryption() {
	        askAgreementTest(REQ_DIR + "AskAgreement" + LAST_PART_REQ_LOCATION);
	    }
	
	    [Test]
	    public void argueAgreementWithEncryption() {
	        askAgreementTest(REQ_DIR + "ArgueAgreement" + LAST_PART_REQ_LOCATION);
	    }
	
	    [Test]
	    public void cancelAgreementWithEncryption() {
	        askAgreementTest(REQ_DIR + "CancelAgreement" + LAST_PART_REQ_LOCATION);
	    }
	    
	    [Test]
	    public void extendAgreementWithEncryption() {
	        askAgreementTest(REQ_DIR + "ExtendAgreement" + LAST_PART_REQ_LOCATION);
	    }
	
	    [Test]
	    public void consultAgreementWithEncryption() {
	        consultAgreementTest(REQ_DIR + "ConsultAgreement" + LAST_PART_REQ_LOCATION);
	    }
	    
	}
	
}
