﻿﻿﻿/*
 * Created by SharpDevelop.
 * User: EH062
 * Date: 07/09/2020
 * Time: 16:27
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using be.ehealth.business.common.domain;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.businessconnector.mycarenet.agreement.builders;
using be.ehealth.businessconnector.mycarenet.agreement.domain;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.mycarenet.agreement.protocol.v1;
using ikvm.extensions;
using org.joda.time;
using NUnit.Framework;

namespace be.ehealth.businessconnector.mycarenet.agreement.session
{
	
	public abstract class AbstractBaseIntegrationTest {
	
	    private static readonly string CHARSET = "utf-8";
	    
		private readonly string patientNiss = "72070539942";
	
	    private string professionalNihii;
	    
	    protected void setProfessionalNihii(string nihii) {
	    	this.professionalNihii = nihii;
	    }
	
	    protected void askAgreementTest(string bundleLocation) {
	        AgreementService service = AgreementSessionServiceFactory.getAgreementService();
	        ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();
	
	        string id = "01-KIN-EMEHS";
	        byte[] bundle = ConnectorIOUtils.getResourceAsString(bundleLocation).getBytes(CHARSET);
	        ConnectorXmlUtils.dump(bundle);
	
	        Patient patientInfo = new Patient();
	        patientInfo.setInss(patientNiss);
	
	        // input reference and AttributeQuery ID must match
	        InputReference inputReference = new InputReference(id);
	        AskAgreementBuilderRequest requestBuilder = RequestObjectBuilderFactory.getEncryptedRequestObjectBuilder().buildAskAgreementRequest(true, inputReference, patientInfo, new DateTime(), bundle);
	
	        AskAgreementResponse response = service.askAgreement((AskAgreementRequest) requestBuilder.getRequest());
	        assertResponse(responseBuilder.handleAskAgreementResponse(response, requestBuilder));
	    }
	
	
	    protected void consultAgreementTest(string bundleLocation) {
	        AgreementService service = AgreementSessionServiceFactory.getAgreementService();
	        ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();
	
	        string id = "01-KIN-EMEHS";
	        byte[] bundle = ConnectorIOUtils.getResourceAsString(bundleLocation).getBytes(CHARSET);
	        ConnectorXmlUtils.dump(bundle);
	
	        Patient patientInfo = new Patient();
	        patientInfo.setInss(patientNiss);
	
	        // input reference and AttributeQuery ID must match
	        InputReference inputReference = new InputReference(id);
	        ConsultAgreementBuilderRequest requestBuilder = RequestObjectBuilderFactory.getEncryptedRequestObjectBuilder().buildConsultAgreementRequest(true, inputReference, patientInfo, new DateTime(), bundle);
	
	        ConsultAgreementResponse response = service.consultAgreement((ConsultAgreementRequest) requestBuilder.getRequest());
	        assertResponse(responseBuilder.handleConsultAgreementResponse(response, requestBuilder));
	    }
	
	
	    private void assertResponse(SignedEncryptedBuilderResponse response) {
	        Assert.IsTrue(response.getSignatureVerificationResult().isValid());
	        Assert.IsNotNull(response.getXades());
	        Assert.IsNotNull(response.getSignedData());
	        Assert.IsNotNull(response.getRawDecryptedBlob());
	   }
	}
	
}
