/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.mycarenet.agreement.builders.impl;

import be.cin.encrypted.BusinessContent;
import be.cin.encrypted.EncryptedKnownContent;
import be.ehealth.business.common.domain.Patient;
import be.ehealth.business.mycarenetcommons.mapper.v3.BlobMapper;
import be.ehealth.business.mycarenetcommons.mapper.v3.CommonInputMapper;
import be.ehealth.business.mycarenetcommons.mapper.v3.RoutingMapper;
import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilder;
import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.builders.CommonBuilder;
import be.ehealth.business.mycarenetdomaincommons.builders.RequestBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.domain.Blob;
import be.ehealth.business.mycarenetdomaincommons.domain.CommonInput;
import be.ehealth.business.mycarenetdomaincommons.domain.InputReference;
import be.ehealth.business.mycarenetdomaincommons.domain.Routing;
import be.ehealth.business.mycarenetdomaincommons.util.McnConfigUtil;
import be.ehealth.businessconnector.mycarenet.agreement.builders.RequestObjectBuilder;
import be.ehealth.businessconnector.mycarenet.agreement.domain.AgreementBuilderRequest;
import be.ehealth.businessconnector.mycarenet.agreement.domain.AskAgreementBuilderRequest;
import be.ehealth.businessconnector.mycarenet.agreement.domain.ConsultAgreementBuilderRequest;
import be.ehealth.businessconnector.mycarenet.agreement.exception.AgreementBusinessConnectorException;
import be.ehealth.businessconnector.mycarenet.agreement.exception.AgreementBusinessConnectorExceptionValues;
import be.ehealth.businessconnector.mycarenet.agreement.security.AgreementEncryptionUtil;
import be.ehealth.businessconnector.mycarenet.agreement.validator.AgreementXmlValidatorImpl;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleBootstrap;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManager;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManagerFactory;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.ehealth.technicalconnector.utils.impl.JaxbContextFactory;
import be.fgov.ehealth.messageservices.core.v1.SendTransactionRequest;
import be.fgov.ehealth.mycarenet.agreement.protocol.v1.AskAgreementRequest;
import be.fgov.ehealth.mycarenet.agreement.protocol.v1.ConsultAgreementRequest;
import be.fgov.ehealth.mycarenet.commons.core.v3.CommonInputType;
import be.fgov.ehealth.mycarenet.commons.core.v3.RoutingType;
import be.fgov.ehealth.technicalconnector.signature.AdvancedElectronicSignatureEnumeration;
import be.fgov.ehealth.technicalconnector.signature.SignatureBuilderFactory;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedRequestObjectBuilderImpl
implements RequestObjectBuilder,
ConfigurationModuleBootstrap.ModuleBootstrapHook {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedRequestObjectBuilderImpl.class);

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public AskAgreementBuilderRequest buildAskAgreementRequest(boolean isTest, InputReference reference, Patient patientInfo, DateTime refDate, byte[] messageFHIR) throws TechnicalConnectorException, AgreementBusinessConnectorException {
        AskAgreementBuilderRequest requestBuilder = new AskAgreementBuilderRequest();
        this.build(isTest, reference, patientInfo, refDate, messageFHIR, requestBuilder);
        return requestBuilder;
    }

    @Override
    public ConsultAgreementBuilderRequest buildConsultAgreementRequest(boolean isTest, InputReference reference, Patient patientInfo, DateTime refDate, byte[] messageFHIR) throws TechnicalConnectorException, AgreementBusinessConnectorException {
        ConsultAgreementBuilderRequest requestBuilder = new ConsultAgreementBuilderRequest();
        this.build(isTest, reference, patientInfo, refDate, messageFHIR, requestBuilder);
        return requestBuilder;
    }

    public <T extends AgreementBuilderRequest> void build(boolean isTest, InputReference references, Patient patientInfo, DateTime refDate, byte[] messageFHIR, T requestBuilder) throws TechnicalConnectorException, AgreementBusinessConnectorException {
        this.checkParameterNotNull(references, "InputReference");
        this.checkParameterNotNull(references.getInputReference(), "Input reference");
        String detailId = "_" + IdGeneratorFactory.getIdGenerator((String)"uuid").generateId();
        BlobBuilder blobBuilder = BlobBuilderFactory.getBlobBuilder((String)"agreement");
        BusinessContent businessContent = new BusinessContent();
        businessContent.setId(detailId);
        businessContent.setValue(messageFHIR);
        requestBuilder.setBusinessContent(businessContent);
        EncryptedKnownContent encryptedKnownContent = new EncryptedKnownContent();
        encryptedKnownContent.setReplyToEtk(KeyDepotManagerFactory.getKeyDepotManager().getETK(KeyDepotManager.EncryptionTokenType.HOLDER_OF_KEY).getEncoded());
        encryptedKnownContent.setBusinessContent(businessContent);
        encryptedKnownContent.setXades(EncryptedRequestObjectBuilderImpl.buildXades(detailId, ConnectorXmlUtils.toByteArray((Object)businessContent)));
        if (LOG.isDebugEnabled()) {
            ConnectorXmlUtils.dump((Object)encryptedKnownContent);
        }
        byte[] payload = null;
        try {
            payload = new AgreementEncryptionUtil<EncryptedKnownContent>().handleEncryption(encryptedKnownContent, SessionUtil.getHolderOfKeyCrypto());
            if (payload != null && ConfigFactory.getConfigValidator().getBooleanProperty("be.ehealth.businessconnector.mycarenet.agreement.builders.impl.dumpMessages", Boolean.valueOf(false)).booleanValue()) {
                LOG.debug("EncryptedRequestObjectBuilder : Created blob content: " + Base64.encodeBase64String((byte[])payload));
            }
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CRYPTO, (Throwable)e, new Object[0]);
        }
        Blob blob = blobBuilder.build(payload, "none", detailId, "text/xml", null, "encryptedForKnownBED");
        Object request = requestBuilder.getRequest();
        CommonBuilder commonBuilder = RequestBuilderFactory.getCommonBuilder((String)"agreement");
        request.setCommonInput(CommonInputMapper.mapCommonInputType((CommonInput)commonBuilder.createCommonInput(McnConfigUtil.retrievePackageInfo((String)"agreement"), isTest, references.getInputReference())));
        request.setRouting(RoutingMapper.mapRoutingType((Routing)commonBuilder.createRouting(patientInfo, refDate)));
        request.setId(IdGeneratorFactory.getIdGenerator((String)"xsid").generateId());
        request.setIssueInstant(new DateTime());
        request.setDetail(BlobMapper.mapBlobTypefromBlob((Blob)blob));
        new AgreementXmlValidatorImpl().validate(request);
    }

    private void checkParameterNotNull(Object references, String parameterName) throws AgreementBusinessConnectorException {
        if (references == null) {
            throw new AgreementBusinessConnectorException(AgreementBusinessConnectorExceptionValues.PARAMETER_NULL, parameterName);
        }
    }

    public static byte[] buildXades(String id, byte[] contentToSign) throws TechnicalConnectorException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        ArrayList<String> tranforms = new ArrayList<String>();
        tranforms.add("http://www.w3.org/2000/09/xmldsig#base64");
        options.put("transformerList", tranforms);
        options.put("baseURI", id);
        return SignatureBuilderFactory.getSignatureBuilder((AdvancedElectronicSignatureEnumeration)AdvancedElectronicSignatureEnumeration.XAdES).sign(SessionUtil.getEncryptionCredential(), contentToSign, options);
    }

    public void bootstrap() {
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{AskAgreementRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{ConsultAgreementRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{SendTransactionRequest.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{CommonInputType.class});
        JaxbContextFactory.initJaxbContext((Class[])new Class[]{RoutingType.class});
    }
}

