/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.policies;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum SigningPolicy {
    EHEALTH_CERT(2048, "2.16.840.1.101.3.4.2.1", "SHA256WITHRSAANDMGF1", "1.2.840.113549.1.1.10", new String[0]),
    EID(1024, "2.16.840.1.101.3.4.2.1", "SHA256withRSA", "1.2.840.113549.1.1.11", "1.2.840.113549.1.1.1"),
    WEB_AUTHN(2048, "2.16.840.1.101.3.4.2.1", "SHA256WITHRSAANDMGF1", "1.2.840.113549.1.1.10", new String[0]);

    private final int signKeySize;
    private final String digestAlgorithmOID;
    private final String signatureAlgorithmName;
    private final String encryptionAlgorithmOID;
    private final List<String> altEncryptionAlgorithmOIDs;

    private SigningPolicy(int signKeySize, String digestAlgorithmOID, String signatureAlgorithmName, String encryptionAlgorithmOID, String ... altEncryptionAlgorithmOID) {
        this.signKeySize = signKeySize;
        this.digestAlgorithmOID = digestAlgorithmOID;
        this.signatureAlgorithmName = signatureAlgorithmName;
        this.encryptionAlgorithmOID = encryptionAlgorithmOID;
        this.altEncryptionAlgorithmOIDs = altEncryptionAlgorithmOID != null && altEncryptionAlgorithmOID.length > 0 ? Arrays.asList(altEncryptionAlgorithmOID) : Collections.emptyList();
    }

    public int getSignKeySize() {
        return this.signKeySize;
    }

    public String getDigestAlgorithmOID() {
        return this.digestAlgorithmOID;
    }

    public String getSignatureAlgorithmName() {
        return this.signatureAlgorithmName;
    }

    public String getEncryptionAlgorithmOID() {
        return this.encryptionAlgorithmOID;
    }

    public List<String> getAltEncryptionAlgorithmOIDs() {
        return this.altEncryptionAlgorithmOIDs;
    }
}

