/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma;

import fr.xebia.extras.selma.InstanceCache;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleInstanceCache
implements InstanceCache {
    private static final ThreadLocal<ThreadLocalInstanceCache> threadContext = new ThreadLocal<ThreadLocalInstanceCache>(){

        @Override
        protected ThreadLocalInstanceCache initialValue() {
            return new ThreadLocalInstanceCache();
        }
    };

    @Override
    public <IN, OUT> OUT get(IN in) {
        return (OUT)threadContext.get().getMap().get(in);
    }

    @Override
    public <IN, OUT> void put(IN in, OUT out) {
        threadContext.get().getMap().put(in, out);
    }

    @Override
    public void push() {
        threadContext.get().getMappingMethodRank().incrementAndGet();
    }

    @Override
    public void pop() {
        int rank = threadContext.get().getMappingMethodRank().decrementAndGet();
        if (rank == 0) {
            threadContext.get().getMap().clear();
        }
    }

    static class ThreadLocalInstanceCache {
        private final AtomicInteger mappingMethodRank = new AtomicInteger(0);
        private final HashMap map = new HashMap();

        ThreadLocalInstanceCache() {
        }

        public AtomicInteger getMappingMethodRank() {
            return this.mappingMethodRank;
        }

        public HashMap getMap() {
            return this.map;
        }
    }
}

