/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.etee;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.ConfigurationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.etee.Crypto;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionItem;
import be.ehealth.technicalconnector.utils.ConfigurableFactoryHelper;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.KeyStoreManager;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import be.fgov.ehealth.etee.crypto.policies.OCSPPolicy;
import be.fgov.ehealth.etee.crypto.policies.SigningOption;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptoFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CryptoFactory.class);
    public static final String PROPS_CRYPTO_CLASS = "crypto.classname";
    private static final String DEFAULT_CERT_CHECKER_CLASS = "be.ehealth.technicalconnector.service.etee.impl.CryptoImpl";
    private static final String TIMESTAMP_SIGNATURE_KEYSTORE_PWD = "timestamp.signature.keystore.pwd";
    private static final String TIMESTAMP_SIGNATURE_KEYSTORE_PATH = "timestamp.signature.keystore.path";
    public static final String SIGNING_TIME_EXPIRATION = "be.fgov.ehealth.etee.crypto.policies.SigningOption.SIGNING_TIME_EXPIRATION";
    public static final String SIGNING_CLOCK_SKEW = "be.fgov.ehealth.etee.crypto.policies.SigningOption.CLOCK_SKEW";
    public static final String SIGNING_TIME_TRUST_IMPLICIT = "be.fgov.ehealth.etee.crypto.policies.SigningOption.SIGNING_TIME_TRUST_IMPLICIT";
    public static final String SIGNING_TSA_CERT_STORE = "be.fgov.ehealth.etee.crypto.policies.SigningOption.TSA_CERT_STORE";
    public static final String OCSP_URI = "be.fgov.ehealth.etee.crypto.policies.OCSPOption.OCSP_URI";
    public static final String OCSP_INJECT_RESPONSE = "be.fgov.ehealth.etee.crypto.policies.OCSPOption.INJECT_RESPONSE";
    public static final String OCSP_CLOCK_SKEW = "be.fgov.ehealth.etee.crypto.policies.OCSPOption.CLOCK_SKEW";
    public static final String OCSP_CONNECTION_TIMEOUT = "be.fgov.ehealth.etee.crypto.policies.OCSPOption.CONNECTION_TIMEOUT";
    public static final String OCSP_CERT_STORE = "be.fgov.ehealth.etee.crypto.policies.OCSPOption.CERT_STORE";
    public static final String OCSP_READ_TIMEOUT = "be.fgov.ehealth.etee.crypto.policies.OCSPOption.READ_TIMEOUT";
    public static final String OCSP_CONNECTION_USER_INTERACTION = "be.fgov.ehealth.etee.crypto.policies.OCSPOption.CONNECTION_USER_INTERACTION";
    private static final String PROP_CAKEYSTORE_PATH = "CAKEYSTORE_LOCATION";
    private static final String PROP_CAKEYSTORE_PASSWORD = "CAKEYSTORE_PASSWORD";
    private static final String PROP_KEYSTORE_DIR = "KEYSTORE_DIR";
    private static Configuration configuration = ConfigFactory.getConfigValidator();
    private static ConfigurableFactoryHelper<Crypto> helper = new ConfigurableFactoryHelper("crypto.classname", "be.ehealth.technicalconnector.service.etee.impl.CryptoImpl");

    private CryptoFactory() {
    }

    public static Crypto getCrypto(Credential encryption, Map<String, PrivateKey> decryptionKeys, String oCSPPolicy) throws TechnicalConnectorException {
        HashMap<String, Object> configParameters = new HashMap<String, Object>();
        configParameters.put("datasealer.credential", encryption);
        configParameters.put("dataunsealer.pkmap", decryptionKeys);
        configParameters.put("cryptolib.ocsp.policy", OCSPPolicy.valueOf((String)oCSPPolicy));
        EnumMap<SigningOption, Object> signingOptions = new EnumMap<SigningOption, Object>(SigningOption.class);
        signingOptions.put(SigningOption.SIGNING_TIME_EXPIRATION, (Object)configuration.getIntegerProperty(SIGNING_TIME_EXPIRATION, 5));
        signingOptions.put(SigningOption.CLOCK_SKEW, (Object)configuration.getLongProperty(SIGNING_CLOCK_SKEW, 300000L));
        signingOptions.put(SigningOption.SIGNING_TIME_TRUST_IMPLICIT, (Object)configuration.getBooleanProperty(SIGNING_TIME_TRUST_IMPLICIT, Boolean.FALSE));
        signingOptions.put(SigningOption.TSA_TRUST_STORE, (Object)CryptoFactory.getKeyStore(TIMESTAMP_SIGNATURE_KEYSTORE_PATH, TIMESTAMP_SIGNATURE_KEYSTORE_PWD));
        signingOptions.put(SigningOption.TSA_CERT_STORE, (Object)CryptoFactory.generateCertStore(SIGNING_TSA_CERT_STORE, new KeyStore[0]));
        configParameters.put("cryptolib.signing.optionmap", signingOptions);
        configParameters.put("cryptolib.ocsp.optionmap", CryptoFactory.getOCSPOptions());
        return helper.getImplementation(configParameters);
    }

    public static Map<OCSPOption, Object> getOCSPOptions() {
        return OCSPOptionHolder.load();
    }

    public static void resetOCSPOptions() {
        OCSPOptionHolder.invalidate();
        OCSPOptionHolder.load();
    }

    public static KeyStore getCaCertificateStore() {
        return CryptoFactory.getKeyStore(PROP_CAKEYSTORE_PATH, PROP_CAKEYSTORE_PASSWORD);
    }

    private static KeyStore getKeyStore(String key, String password) {
        try {
            KeyStore keystore = null;
            char[] pwd = configuration.getProperty(password, "").toCharArray();
            String path = configuration.getProperty(key, "");
            if (StringUtils.isNotBlank((String)path)) {
                String keystorePath = configuration.getProperty(PROP_KEYSTORE_DIR, "") + path;
                keystore = CryptoFactory.loadKeyStore(keystore, pwd, keystorePath);
            }
            if (keystore == null) {
                keystore = KeyStore.getInstance("JKS");
                keystore.load(null, password.toCharArray());
            }
            if (LOG.isDebugEnabled()) {
                Enumeration<String> aliases = keystore.aliases();
                LOG.debug("Current keystore [{}] content is: ", (Object)key);
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    LOG.debug(" .[{}] {} ", (Object)alias, (Object)((X509Certificate)keystore.getCertificate(alias)).getSubjectX500Principal().getName("RFC1779"));
                }
            }
            return keystore;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private static KeyStore loadKeyStore(KeyStore keystore, char[] pwd, String keystorePath) {
        try {
            KeyStoreManager ocspKeyStoreManager = new KeyStoreManager(keystorePath, pwd);
            keystore = ocspKeyStoreManager.getKeyStore();
        }
        catch (TechnicalConnectorException e) {
            LOG.info("Unable to load keystore.", (Throwable)e);
        }
        return keystore;
    }

    public static Crypto getCrypto(Credential encryption, Map<String, PrivateKey> decryptionKeys) throws TechnicalConnectorException {
        return CryptoFactory.getCrypto(encryption, decryptionKeys, "NONE");
    }

    public static Crypto getCryptoFromSession() throws TechnicalConnectorException {
        SessionItem session = Session.getInstance().getSession();
        return CryptoFactory.getCrypto(session.getEncryptionCredential(), session.getEncryptionPrivateKeys());
    }

    private static CertStore generateCertStore(String baseKey, KeyStore ... stores) {
        try {
            ArrayList certsAndCrls = new ArrayList();
            for (KeyStore store : stores) {
                CryptoFactory.process(certsAndCrls, store);
            }
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            for (String certLocation : configuration.getMatchingProperties(baseKey + ".CERT")) {
                CryptoFactory.processCERT(certsAndCrls, factory, certLocation);
            }
            for (String crlLocation : configuration.getMatchingProperties(baseKey + ".CRL")) {
                CryptoFactory.processCRL(certsAndCrls, factory, crlLocation);
            }
            return CertStore.getInstance("Collection", new CollectionCertStoreParameters(certsAndCrls));
        }
        catch (CertificateException e) {
            LOG.error(e.getClass().getName() + ":" + e.getMessage(), (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOG.error(e.getClass().getName() + ":" + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error(e.getClass().getName() + ":" + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCRL(Collection certsAndCrls, CertificateFactory factory, String crlLocation) {
        InputStream stream = null;
        try {
            stream = ConnectorIOUtils.getResourceAsStream(crlLocation);
            certsAndCrls.add(factory.generateCRL(stream));
            LOG.info("Added {} as CRL in CertStore.", (Object)crlLocation);
        }
        catch (Exception e) {
            LOG.error(e.getClass().getName() + ":" + e.getMessage(), (Throwable)e);
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCERT(Collection certsAndCrls, CertificateFactory factory, String certLocation) {
        InputStream stream = null;
        try {
            stream = ConnectorIOUtils.getResourceAsStream(certLocation);
            certsAndCrls.add(factory.generateCertificate(stream));
            LOG.info("Added " + certLocation + " as CERT in CertStore.");
        }
        catch (Exception e) {
            LOG.error(e.getClass().getName() + ":" + e.getMessage(), (Throwable)e);
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)stream);
        }
    }

    private static void process(Collection certsAndCrls, KeyStore store) {
        try {
            Enumeration<String> enumeration = store.aliases();
            while (enumeration.hasMoreElements()) {
                Certificate cert = store.getCertificate(enumeration.nextElement());
                if (LOG.isDebugEnabled() && cert instanceof X509Certificate) {
                    LOG.debug("Adding certificate {}", (Object)((X509Certificate)cert).getSubjectX500Principal().getName("RFC1779"));
                }
                certsAndCrls.add(cert);
            }
            LOG.info("Added truststore in CertStore.");
        }
        catch (KeyStoreException e) {
            LOG.warn("Unable to add truststore to CertStore", (Throwable)e);
        }
    }

    private static class OCSPOptionHolder {
        private static Map<OCSPOption, Object> ocspOptionMap;

        private OCSPOptionHolder() {
        }

        public static synchronized Map<OCSPOption, Object> load() {
            if (ocspOptionMap == null) {
                EnumMap<OCSPOption, Object> map = new EnumMap<OCSPOption, Object>(OCSPOption.class);
                map.put(OCSPOption.OCSP_URI, (Object)configuration.getProperty(CryptoFactory.OCSP_URI));
                KeyStore trustStore = CryptoFactory.getCaCertificateStore();
                map.put(OCSPOption.TRUST_STORE, (Object)trustStore);
                map.put(OCSPOption.CERT_STORE, (Object)CryptoFactory.generateCertStore(CryptoFactory.OCSP_CERT_STORE, new KeyStore[]{trustStore}));
                map.put(OCSPOption.INJECT_RESPONSE, (Object)configuration.getBooleanProperty(CryptoFactory.OCSP_INJECT_RESPONSE, Boolean.FALSE));
                map.put(OCSPOption.CLOCK_SKEW, (Object)configuration.getLongProperty(CryptoFactory.OCSP_CLOCK_SKEW, 300000L));
                map.put(OCSPOption.CONNECTION_TIMEOUT, (Object)configuration.getIntegerProperty(CryptoFactory.OCSP_CONNECTION_TIMEOUT, 3000));
                map.put(OCSPOption.READ_TIMEOUT, (Object)configuration.getIntegerProperty(CryptoFactory.OCSP_READ_TIMEOUT, 3000));
                map.put(OCSPOption.CONNECTION_USER_INTERACTION, (Object)configuration.getBooleanProperty(CryptoFactory.OCSP_CONNECTION_USER_INTERACTION, Boolean.FALSE));
                ocspOptionMap = Collections.unmodifiableMap(map);
            }
            return ocspOptionMap;
        }

        public static synchronized void invalidate() {
            ocspOptionMap = null;
        }
    }
}

