/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.mapper;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.mapper.Mapper;
import be.ehealth.technicalconnector.mapper.impl.MapperDozerImpl;
import be.ehealth.technicalconnector.utils.ConfigurableFactoryHelper;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.util.encoders.Base64;

public final class MapperFactory {
    private static ConfigurableFactoryHelper<Mapper> helper = new ConfigurableFactoryHelper(MapperDozerImpl.class.getName(), MapperDozerImpl.class.getName());
    private static Map<String, Mapper> cache = new HashMap<String, Mapper>();

    private MapperFactory() {
    }

    public static Mapper getMapper(String ... mappingFiles) {
        TreeSet<String> mappingSet = new TreeSet<String>();
        mappingSet.addAll(Arrays.asList(mappingFiles));
        MessageDigest complete = DigestUtils.getMd5Digest();
        for (String mapping : mappingSet) {
            complete.update(mapping.getBytes());
        }
        String key = new String(Base64.encode((byte[])complete.digest()));
        if (!cache.containsKey(key)) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("be.ehealth.technicalconnector.mapper.configfiles", mappingFiles);
            try {
                cache.put(key, helper.getImplementation(options));
            }
            catch (TechnicalConnectorException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return cache.get(key);
    }
}

