/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.utils;


import java.util.Arrays;
import java.util.Collection;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;


/**
 * tests the IdentifierType object.
 * 
 * @author EH054
 * 
 */
@RunWith(Parameterized.class)
public class IdentifierTypeTest {

    private String type;

    private String subtype;

    private int source;

    @Parameters(name = "LookupTest {0} - {1} - {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
            {"CBE", null, IdentifierType.ETKDEPOT},
            {"CBE", null, IdentifierType.EHBOX},
            {"CBE", null, IdentifierType.RECIPE},
            
            {"SSIN", null, IdentifierType.ETKDEPOT},
            {"INSS", null, IdentifierType.EHBOX},
            {"SSIN", null, IdentifierType.RECIPE},
            
            {"NIHII", null, IdentifierType.ETKDEPOT},
            {"NIHII", null, IdentifierType.EHBOX},
            {"NIHII", null, IdentifierType.RECIPE},
            
            {"NIHII11", null, IdentifierType.ETKDEPOT},
            {"NIHII11", null, IdentifierType.EHBOX},
            {"NIHII11", null, IdentifierType.RECIPE},
            
            {"NIHII-PHARMACY", null, IdentifierType.ETKDEPOT},
            {"NIHII", "PHARMACY", IdentifierType.EHBOX},
            {"NIHII-PHARMACY", null, IdentifierType.RECIPE},
            
            {"NIHII-LABO", null, IdentifierType.ETKDEPOT},
            {"NIHII", "LABO", IdentifierType.EHBOX},
            {"NIHII-LABO", null, IdentifierType.RECIPE},
            
            {"NIHII-RETIREMENT", null, IdentifierType.ETKDEPOT},
            {"NIHII", "RETIREMENT", IdentifierType.EHBOX},
            {"NIHII-RETIREMENT", null, IdentifierType.RECIPE},
            
            {"NIHII-OTD_PHARMACY", null, IdentifierType.ETKDEPOT},
            {"NIHII", "OTD_PHARMACY", IdentifierType.EHBOX},
            {"NIHII-OTD_PHARMACY", null, IdentifierType.RECIPE},
            
            {"NIHII-HOSPITAL", null, IdentifierType.ETKDEPOT},
            {"NIHII", "HOSPITAL", IdentifierType.EHBOX},
            {"NIHII-HOSPITAL", null, IdentifierType.RECIPE},
            
            {"NIHII-GROUP", null, IdentifierType.ETKDEPOT},
            {"NIHII", "GROUP", IdentifierType.EHBOX},
            {"NIHII-GROUP", null, IdentifierType.RECIPE},
            
            {"EHP", null, IdentifierType.ETKDEPOT},
            {"EHP", null, IdentifierType.EHBOX},
        });
    }

    /**
     * constructor for parameterized test
     * 
     * @param type
     * @param subtype
     * @param source
     */
    public IdentifierTypeTest(String type, String subtype, int source) {
        super();
        this.type = type;
        this.subtype = subtype;
        this.source = source;
    }

    /**
     * Test method for {@link be.ehealth.technicalconnector.utils.IdentifierType#lookup(java.lang.String, java.lang.String, int)}.
     */
    @Test
    public void testLookup() {
        IdentifierType lookup = IdentifierType.lookup(type, subtype, source);
        Assert.assertNotNull(lookup);
        Assert.assertEquals(type, lookup.getType(source));
        Assert.assertEquals(subtype, lookup.getSubType(source));

    }

}
