/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.signature.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Map;
import org.apache.xml.security.algorithms.JCEMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignatureUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureUtils.class);

    private SignatureUtils() {
        throw new UnsupportedOperationException();
    }

    public static <T> T getOption(String key, Map<String, Object> optionMap, T defaultValue) {
        Object result = defaultValue;
        if (optionMap == null) {
            return result;
        }
        if (optionMap.containsKey(key) && optionMap.get(key) != null) {
            result = optionMap.get(key);
        }
        LOG.debug("Using the following " + key + " : [" + result + "]");
        return result;
    }

    public static MessageDigest getDigestInstance(String algorithmURI) throws NoSuchAlgorithmException {
        MessageDigest md;
        String algorithmID = JCEMapper.translateURItoJCEID((String)algorithmURI);
        if (algorithmID == null) {
            throw new NoSuchAlgorithmException("Could not translate algorithmURI [" + algorithmURI + "]");
        }
        String provider = JCEMapper.getProviderId();
        try {
            md = provider == null ? MessageDigest.getInstance(algorithmID) : MessageDigest.getInstance(algorithmID, provider);
        }
        catch (NoSuchProviderException ex) {
            throw new NoSuchAlgorithmException("Could not find provider for [" + algorithmID + "]", ex);
        }
        return md;
    }
}

