/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.enumeration.Charset;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import com.gc.iotools.stream.is.InputStreamFromOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectorIOUtils {
    private static final String BASE64_VALIDATOR_REGEX = "^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$";
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorIOUtils.class);
    public static final String COMPRESSION_ALGO_DEFLATE = "deflate";
    public static final String COMPRESSION_ALGO_GZIP = "gz";
    private static CompressorStreamFactory factory = new CompressorStreamFactory();
    private static ArchiveStreamFactory asFactory = new ArchiveStreamFactory();

    private ConnectorIOUtils() {
        throw new UnsupportedOperationException();
    }

    public static byte[] getBytes(InputStream inputStream) throws TechnicalConnectorException {
        if (inputStream == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[0]);
        }
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        catch (IOException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)inputStream);
        }
    }

    public static byte[] toBytes(String content, Charset charsetName) throws TechnicalConnectorException {
        byte[] bytes = null;
        if (content == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[0]);
        }
        if (charsetName == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[0]);
        }
        try {
            bytes = content.getBytes(charsetName.getName());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.UNSUPPORTED_ENCODING_EXCEPTION, (Throwable)e, e.getMessage());
        }
        return bytes;
    }

    public static String toString(byte[] message, Charset charsetName) throws TechnicalConnectorException {
        Validate.notNull((Object)message);
        Validate.notNull((Object)((Object)charsetName));
        try {
            return new String(message, charsetName.getName());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unable to convert input.", (Throwable)e);
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.UNSUPPORTED_ENCODING_EXCEPTION, (Throwable)e, e.getMessage());
        }
    }

    public static byte[] compress(byte[] input) throws TechnicalConnectorException {
        return ConnectorIOUtils.compress(input, COMPRESSION_ALGO_GZIP);
    }

    @Deprecated
    public static byte[] compress(boolean noWrap, byte[] input) throws TechnicalConnectorException {
        return ConnectorIOUtils.compress(input);
    }

    public static void compress(InputStream in, OutputStream out, String algo) throws TechnicalConnectorException {
        CompressorOutputStream gzippedOut;
        DeflaterInputStream compressedInputStream;
        block5: {
            compressedInputStream = null;
            gzippedOut = null;
            try {
                if (COMPRESSION_ALGO_DEFLATE.equalsIgnoreCase(algo)) {
                    compressedInputStream = new DeflaterInputStream(in, new Deflater(-1, true));
                    IOUtils.copy((InputStream)compressedInputStream, (OutputStream)out);
                    break block5;
                }
                gzippedOut = factory.createCompressorOutputStream(algo, out);
                IOUtils.copy((InputStream)in, (OutputStream)gzippedOut);
            }
            catch (Exception e) {
                try {
                    LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
                    throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_COMPRESSION, (Throwable)e, new Object[0]);
                }
                catch (Throwable throwable) {
                    ConnectorIOUtils.closeQuietly(compressedInputStream, gzippedOut);
                    throw throwable;
                }
            }
        }
        ConnectorIOUtils.closeQuietly(compressedInputStream, gzippedOut);
    }

    public static byte[] compress(byte[] input, String algo) throws TechnicalConnectorException {
        byte[] byArray;
        if (ArrayUtils.isEmpty((byte[])input) || StringUtils.isEmpty((String)algo)) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[0]);
        }
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(input);
            out = new ByteArrayOutputStream();
            ConnectorIOUtils.compress(in, (OutputStream)out, algo);
            out.flush();
            byArray = out.toByteArray();
        }
        catch (IOException e) {
            try {
                LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_COMPRESSION, (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(in, out);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly(in, out);
        return byArray;
    }

    public static void decompress(InputStream in, OutputStream out, boolean noWrap) throws TechnicalConnectorException {
        InflaterOutputStream decompressed = null;
        try {
            decompressed = new InflaterOutputStream(out, new Inflater(noWrap));
            IOUtils.copy((InputStream)in, (OutputStream)decompressed);
        }
        catch (Exception e) {
            try {
                LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_COMPRESSION, (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(decompressed);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly((Object)decompressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] input) throws TechnicalConnectorException {
        byte[] byArray;
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(input);
            byArray = ConnectorIOUtils.getBytes(ConnectorIOUtils.decompress(in));
        }
        catch (Throwable throwable) {
            ConnectorIOUtils.closeQuietly(in);
            throw throwable;
        }
        ConnectorIOUtils.closeQuietly((Object)in);
        return byArray;
    }

    public static InputStream decompress(InputStream input) throws TechnicalConnectorException {
        Validate.notNull((Object)input);
        BufferedInputStream is = new BufferedInputStream(input);
        is.mark(1024);
        try {
            try {
                LOG.debug("Using createCompressorInputStream");
                return factory.createCompressorInputStream((InputStream)is);
            }
            catch (Exception e) {
                LOG.debug("[CompressionFactory]   " + e.getClass().getSimpleName() + ": " + e.getMessage());
                is.reset();
                try {
                    LOG.debug("Using createArchiveInputStream");
                    return asFactory.createArchiveInputStream((InputStream)is);
                }
                catch (Exception e2) {
                    LOG.debug("[ArchiveStreamFactory] " + e2.getClass().getSimpleName() + ": " + e2.getMessage());
                    is.reset();
                    try {
                        LOG.debug("Using deflater noWrap");
                        return ConnectorIOUtils.deflater(is, true);
                    }
                    catch (Exception e3) {
                        LOG.debug("[Deflater noWrap] " + e3.getClass().getSimpleName() + ": " + e3.getMessage());
                        is.reset();
                        try {
                            LOG.debug("Using deflater wrap");
                            return ConnectorIOUtils.deflater(is, false);
                        }
                        catch (Exception e4) {
                            LOG.debug("[Deflater wrap] " + e4.getClass().getSimpleName() + ": " + e4.getMessage());
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_COMPRESSION, (Throwable)e, e.getMessage());
        }
        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_COMPRESSION, "Unsupported compression algorithm.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream deflater(final InputStream is, final boolean noWrap) throws Exception {
        AutoDeleteFileInputStream autoDeleteFileInputStream;
        InputStreamFromOutputStream<Void> result = new InputStreamFromOutputStream<Void>(){

            protected Void produce(OutputStream sink) throws Exception {
                ConnectorIOUtils.decompress(is, sink, noWrap);
                return null;
            }
        };
        FileOutputStream fos = null;
        try {
            File temp = File.createTempFile("connector-io-", ".tmp");
            fos = new FileOutputStream(temp);
            IOUtils.copy((InputStream)result, (OutputStream)fos);
            autoDeleteFileInputStream = new AutoDeleteFileInputStream(temp);
        }
        catch (Throwable throwable) {
            ConnectorIOUtils.closeQuietly(fos);
            throw throwable;
        }
        ConnectorIOUtils.closeQuietly((Object)fos);
        return autoDeleteFileInputStream;
    }

    @Deprecated
    public static byte[] decompress(boolean noWrap, byte[] input) throws TechnicalConnectorException {
        return ConnectorIOUtils.decompress(input);
    }

    public static InputStream getResourceAsStream(String location) throws TechnicalConnectorException {
        return ConnectorIOUtils.getResourceAsStream(location, true);
    }

    public static String getResourceAsString(String location) throws TechnicalConnectorException {
        return ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream(location));
    }

    public static byte[] getResourceAsByteArray(String location) throws TechnicalConnectorException {
        return ConnectorIOUtils.getBytes(ConnectorIOUtils.getResourceAsStream(location));
    }

    public static InputStream getResourceAsStream(String location, boolean bootstrap) throws TechnicalConnectorException {
        if (location == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[0]);
        }
        LOG.debug("Loading [" + location + "] as ResourceAsStream.");
        InputStream stream = ConnectorIOUtils.class.getResourceAsStream(location);
        if (stream == null) {
            File file = new File(location);
            if (!file.exists()) {
                try {
                    LOG.debug("Loading [" + location + "] as URL.");
                    if (bootstrap) {
                        ConfigFactory.getConfigValidator().getConfig();
                    }
                    URL resource = new URL(location);
                    return resource.openStream();
                }
                catch (Exception e) {
                    LOG.error("Location [" + location + "] could not be retrieved as URL, classpath resource or file.");
                    throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.MALFORMED_URL, (Throwable)e, location);
                }
            }
            try {
                LOG.debug("Loading [" + location + "] as FileInputStream.");
                stream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.MALFORMED_URL, (Throwable)e, location);
            }
        }
        return stream;
    }

    public static File getResourceAsFile(String location) throws TechnicalConnectorException {
        File file;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            File tempFile = File.createTempFile("connector-io", ".tmp");
            tempFile.deleteOnExit();
            out = new FileOutputStream(tempFile);
            in = ConnectorIOUtils.getResourceAsStream(location);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            file = tempFile;
        }
        catch (IOException e) {
            try {
                LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.MALFORMED_URL, (Throwable)e, location);
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(in, out);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly(in, out);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceFilePath(String location) throws TechnicalConnectorException {
        String filePath;
        block8: {
            if (location == null) {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[0]);
            }
            filePath = null;
            LOG.debug("Loading " + location + " as ResourceAsString");
            InputStream stream = null;
            try {
                stream = ConnectorIOUtils.class.getResourceAsStream(location);
                if (stream != null) {
                    LOG.debug("Location found as Resource.");
                    filePath = ConnectorIOUtils.class.getResource(location).getFile();
                    break block8;
                }
                File file = new File(location);
                if (!file.exists()) {
                    try {
                        URL resource = new URL(location);
                        filePath = resource.getFile();
                        LOG.debug("Location found as URL.");
                        break block8;
                    }
                    catch (MalformedURLException e) {
                        LOG.error("location [" + location + "] could not be retrieved as URL, classpath resource or file.");
                        throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.MALFORMED_URL, (Throwable)e, "location ]" + location + "[ errorMessage :" + e.getMessage());
                    }
                }
                LOG.debug("Location found as File.");
                filePath = location;
            }
            finally {
                ConnectorIOUtils.closeQuietly((Object)stream);
            }
        }
        return filePath;
    }

    public static String convertStreamToString(InputStream is) throws TechnicalConnectorException {
        String result;
        if (is == null) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, new Object[0]);
        }
        try {
            result = IOUtils.toString((InputStream)is, (String)Charset.UTF_8.getName());
        }
        catch (IOException e) {
            LOG.error(e.getClass().getSimpleName() + ": " + e.getMessage());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_IOEXCEPTION, (Throwable)e, e.getMessage());
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)is);
        }
        return result;
    }

    public static void closeQuietly(Object closeable) {
        try {
            if (closeable != null) {
                Method closeMethod = closeable.getClass().getMethod("close", new Class[0]);
                closeMethod.invoke(closeable, new Object[0]);
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Object ... closeables) {
        for (Object closeable : closeables) {
            ConnectorIOUtils.closeQuietly(closeable);
        }
    }

    @Deprecated
    public static byte[] base64Decode(byte[] input) throws TechnicalConnectorException {
        return ConnectorIOUtils.base64Decode(input, false);
    }

    public static byte[] base64Decode(byte[] input, boolean recursive) throws TechnicalConnectorException {
        byte[] result = ArrayUtils.clone((byte[])input);
        String content = ConnectorIOUtils.toString(result, Charset.UTF_8);
        if (content.matches(BASE64_VALIDATOR_REGEX)) {
            result = Base64.decode((byte[])result);
            if (recursive) {
                result = ConnectorIOUtils.base64Decode(result, recursive);
            }
        }
        return result;
    }

    public static File createTempFile(String name) throws TechnicalConnectorException {
        if (name == null || name.isEmpty()) {
            LOG.error("The name given for the tempFile is empty");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, "The name given for the tempFile is empty");
        }
        String tempDirectory = System.getProperty("java.io.tmpdir");
        if (tempDirectory == null || tempDirectory.isEmpty()) {
            LOG.error("The property 'java.io.tmpdir' not found in the system properties");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, "The property 'java.io.tmpdir' not found in the system properties");
        }
        File tempFile = new File(tempDirectory, name);
        try {
            tempFile.createNewFile();
        }
        catch (IOException e) {
            LOG.error("IOException while creating temporary file {0}", (Object)tempFile.getPath());
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_IOEXCEPTION, e.getMessage(), e, "creating temporary file" + tempFile.getPath());
        }
        return tempFile;
    }

    public static String getTempFileLocation(String name) throws TechnicalConnectorException {
        if (name == null || name.isEmpty()) {
            LOG.error("The name given for the tempFile is empty");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_INPUT_PARAMETER_NULL, "The name given for the tempFile is empty");
        }
        String tempDirectory = System.getProperty("java.io.tmpdir");
        if (tempDirectory == null || tempDirectory.isEmpty()) {
            LOG.error("The property 'java.io.tmpdir' not found in the system properties");
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_CONFIG, "The property 'java.io.tmpdir' not found in the system properties");
        }
        File tempFile = new File(tempDirectory, name);
        return tempFile.getPath();
    }

    private static class AutoDeleteFileInputStream
    extends FileInputStream {
        private static final Logger LOGGER = LoggerFactory.getLogger(AutoDeleteFileInputStream.class);
        private File file;
        private boolean isClosed;
        private boolean isDeleted;

        public AutoDeleteFileInputStream(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
            this.file.deleteOnExit();
        }

        @Override
        public void close() {
            if (this.isClosed) {
                LOGGER.debug("stream already closed");
                return;
            }
            LOGGER.debug("closing stream :{}" + this.file);
            this.isClosed = true;
            try {
                super.close();
                this.isDeleted = this.file.delete();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close stream: {}", (Object)this, (Object)e);
            }
            catch (RuntimeException e) {
                LOGGER.warn("Failed to delete underlying file: {}", (Object)this.file, (Object)e);
            }
            LOGGER.debug("close()- file [{}] deleted: {}", (Object)this.file, (Object)this.isDeleted);
        }
    }
}

