/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.service.sts.utils;

import be.ehealth.technicalconnector.utils.DateUtils;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import org.joda.time.DateTime;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class SAMLHelper {
    public static final String SAML_CONDITIONS = "Conditions";
    public static final String SAML_NOTONORAFTER = "NotOnOrAfter";
    public static final String SAML_SUCCESS = "Success";
    public static final String SAML_STATUSCODE = "StatusCode";
    public static final String SAML_STATUSMESSAGE = "StatusMessage";
    public static final String SAML_VALUE = "Value";
    public static final String SAML_ASSERTION = "Assertion";
    public static final String SAML_ATTRIBUTESTATEMENT = "AttributeStatement";
    public static final String SAML_ATTRIBUTE = "Attribute";

    private SAMLHelper() {
    }

    public static String getStatusCode(Element stsResponse) {
        return stsResponse.getElementsByTagNameNS("*", SAML_STATUSCODE).item(0).getAttributes().getNamedItem(SAML_VALUE).getNodeValue();
    }

    public static String getStatusMessage(Element stsResponse) {
        return stsResponse.getElementsByTagNameNS("*", SAML_STATUSMESSAGE).item(0).getTextContent();
    }

    @Deprecated
    public static Calendar getNotOnOrAfterConditions(Element stsResponse) {
        return DatatypeConverter.parseDate((String)stsResponse.getElementsByTagNameNS("*", SAML_CONDITIONS).item(0).getAttributes().getNamedItem(SAML_NOTONORAFTER).getTextContent());
    }

    public static DateTime getNotOnOrAfterCondition(Element stsResponse) {
        return DateUtils.parseDateTime((String)stsResponse.getElementsByTagNameNS("*", SAML_CONDITIONS).item(0).getAttributes().getNamedItem(SAML_NOTONORAFTER).getTextContent());
    }

    public static NodeList getAttributes(Element stsResponse) {
        return ((Element)stsResponse.getElementsByTagNameNS("*", SAML_ATTRIBUTESTATEMENT).item(0)).getElementsByTagNameNS("*", SAML_ATTRIBUTE);
    }

    public static Element getAssertion(Element stsResponse) {
        return (Element)stsResponse.getElementsByTagNameNS("*", SAML_ASSERTION).item(0);
    }
}

