﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.technicalconnector.idgenerator;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.hubservices.core.v1;
using NUnit.Framework;
using org.joda.time;
using be.ehealth.businessconnector.hub.builders;
using be.ehealth.business.intrahubcommons.exception;
using be.ehealth.businessconnector.hub.service;
using be.ehealth.technicalconnector.exception;
using be.fgov.ehealth.standards.kmehr.cd.v1;
using be.fgov.ehealth.standards.kmehr.id.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;
using be.ehealth.business.kmehrcommons.helper;
using org.apache.commons.lang;

namespace be.ehealth.businessconnector.hub.session
{
	/**
	 * Integration test for {@link HubServiceComplete}
	 * 
	 * @author EHP
	 * 
	 */
	[TestFixture]
	public class HubServiceCompleteIntegrationTest:AbstractIntrahubIntegrationTest
	{
		private static String PATIENT_INSS = "56032815112";
		private static String PATIENT_CARDNO = "592313215610";
        private static String PATIENT_FIRSTNAME = "Daniel";
        private static String PATIENT_LASTNAME = "Homerin";
        private static String PROF_INSS = "82051234978";
        private static String PROF_FIRSTNAME = "Hannes";
        private static String PROF_LASTNAME = "De Clercq";
        private static String HUB_NAME = "RSW";
    	private static String PROF_PROFESSION = CDHCPARTYvalues.PERSPHYSICIAN.value();
    	
    	private static String transactionId;

	    private static HubServiceComplete hubServiceComplete;
	
	    [SetUp]
	    public static void initHubServiceCompleteIntegrationTest() {
	        hubServiceComplete = HubSessionServiceFactory.getHubServiceComplete();
	        initHub(AbstractIntrahubIntegrationTest.HUBID_RSW);
	    }
	    
	    
	    [Test]
        public void _01_putHcPartyConsent() {
            ConsentHCPartyType consent = new ConsentHCPartyType();
            consent.setAuthor(createAuthor());
            consent.setHcparty(createHcPartyIdProfessional());
            consent.setRevokedate(new org.joda.time.DateTime());
            consent.setSigndate(new org.joda.time.DateTime());
            PutHCPartyConsentResponse putHCPartyConsent = hubServiceComplete.putHCPartyConsent(consent);
    
            java.util.List errors = putHCPartyConsent.getAcknowledge().getErrors();
            Assert.IsTrue(errors.isEmpty() || StringUtils.contains(((CDERROR) ((ErrorType) errors.get(0)).getCds().get(0)).getValue(), "PERHCP.CONSENT.EXISTS"), ErrorTypeManagement.printErrors(errors));
        }
        
        [Test]
        public void _02_putPatient() {
            PersonType person = createPatient();
            PutPatientResponse putPatient = hubServiceComplete.putPatient(person);
    
            java.util.List errors = putPatient.getAcknowledge().getErrors();
            Assert.IsTrue(errors.isEmpty(), ErrorTypeManagement.printErrors(errors));
        }
        
        [Test]
        public void _03_putPatientConsent() {
            ConsentType consent = createConsentType();
            PutPatientConsentResponse putPatientConsent = hubServiceComplete.putPatientConsent(consent);
    
            java.util.List errors = putPatientConsent.getAcknowledge().getErrors();
            Assert.IsTrue(errors.isEmpty(), ErrorTypeManagement.printErrors(errors));
        }
        
        [Test]
        public void _04_putTherapeuticLink() {
            TherapeuticLinkType therapeuticLink = createTherapeuticLinkType();
            PutTherapeuticLinkResponse putTherapeuticLink = hubServiceComplete.putTherapeuticLink(therapeuticLink);
    
            java.util.List errors = putTherapeuticLink.getAcknowledge().getErrors();
            Assert.IsTrue(errors.isEmpty(), ErrorTypeManagement.printErrors(errors));
        }
        
        [Test]
        public void _05_putTransaction() {
            Kmehrmessage kmehrmessage = createTransactionForPut();
            ConnectorXmlUtils.dump(kmehrmessage);
            PutTransactionResponse putTransaction = hubServiceComplete.putTransaction(kmehrmessage);
            transactionId = ((IDKMEHR) ((TransactionType) ((be.fgov.ehealth.standards.kmehr.schema.v1.FolderType) kmehrmessage.getFolders().get(0)).getTransactions().get(0)).getIds().get(2)).getValue();
    
            java.util.List errors = putTransaction.getAcknowledge().getErrors();
            Assert.IsTrue(errors.isEmpty(), ErrorTypeManagement.printErrors(errors));
        }
        
        [Test]
        public void _06_getTherapeuticLink() {
            GetTherapeuticLinkResponse getResponse = hubServiceComplete.getTherapeuticLink(createSelectGetHCPartyPatientConsentType());
    
            java.util.List errors = getResponse.getAcknowledge().getErrors();
            Assert.IsTrue(errors.isEmpty(), ErrorTypeManagement.printErrors(errors));
        }
        
        [Test]
        public void _07_getTransactionList() {
            PatientIdType patientId = createPatientIdType();
            GetTransactionListResponse transactionList = hubServiceComplete.getTransactionList(patientId, LocalSearchType.LOCAL, createTransactionWithPeriodType());
    
            java.util.List errors = transactionList.getAcknowledge().getErrors();
            Assert.IsTrue(errors.isEmpty(), ErrorTypeManagement.printErrors(errors));
        }
        
        [Test]
        public void _08_getPatientConsent() {
            GetPatientConsentResponse patientConsent = hubServiceComplete.getPatientConsent(createSelectGetPatientConsentType());
    
            java.util.List errors = patientConsent.getAcknowledge().getErrors();
            Assert.IsTrue(errors.isEmpty(), ErrorTypeManagement.printErrors(errors));
        }
    
        [Test]
        public void _09_getTransaction() {
            PatientIdType patientId = createPatientIdType();
            GetTransactionResponse transactionResponse = hubServiceComplete.getTransaction(patientId, createTransactionBaseType());
    
            java.util.List errors = transactionResponse.getAcknowledge().getErrors();
            Assert.IsTrue(errors.isEmpty(), ErrorTypeManagement.printErrors(errors));
        }
    
        [Test]
        public void _10_revokeTransaction() {
            RevokeTransactionResponse revokeTransaction = hubServiceComplete.revokeTransaction(createPatientIdType(), createTransactionId());
    
            java.util.List errors = revokeTransaction.getAcknowledge().getErrors();
            Assert.IsTrue(errors.isEmpty(), ErrorTypeManagement.printErrors(errors));
        }
            
        [Test]
        public void _11_getPatient() {
            hubServiceComplete.getPatient(createPatientIdType());
        }
            	
        [Test]
        public void _12_getPatientAuditTrail() {
            SelectGetPatientAuditTrailType patientAudiTrail = new SelectGetPatientAuditTrailType();
            patientAudiTrail.setBegindate(new org.joda.time.DateTime());
            patientAudiTrail.setEnddate(new org.joda.time.DateTime());
            patientAudiTrail.setHcparty(createHcParty());
            patientAudiTrail.setPatient(createPatientIdType());
            patientAudiTrail.setSearchtype(LocalSearchType.LOCAL);
            patientAudiTrail.setTransaction(createTransaction());
            hubServiceComplete.getPatientAuditTrail(patientAudiTrail);
        }
            	
        
        [Test]
        public void _13_revokeTherapeuticLink() {
            TherapeuticLinkType therapeuticLink = createTherapeuticLinkType();
            therapeuticLink.setEnddate(new org.joda.time.DateTime());
            RevokeTherapeuticLinkResponse revokeTherapeuticLink = hubServiceComplete.revokeTherapeuticLink(therapeuticLink);
    
            java.util.List errors = revokeTherapeuticLink.getAcknowledge().getErrors();
            Assert.IsTrue(errors.isEmpty(), ErrorTypeManagement.printErrors(errors));
        }
    
        [Test]
        public void _14_revokePatientConsent() {
            ConsentType consent = createConsentType();
            consent.setRevokedate(new org.joda.time.DateTime());
            RevokePatientConsentResponse revokePatientConsent = hubServiceComplete.revokePatientConsent(consent);
    
            java.util.List errors = revokePatientConsent.getAcknowledge().getErrors();
            Assert.IsTrue(errors.isEmpty(), ErrorTypeManagement.printErrors(errors));
        }
            
        [Test]
        [ExpectedException(typeof(KmehrBusinessConnectorException))]
        public void _16_declareTransaction() {
            KmehrHeaderDeclareTransaction kmehrHeader = new KmehrHeaderDeclareTransaction();
            be.fgov.ehealth.hubservices.core.v1.FolderType folder = new be.fgov.ehealth.hubservices.core.v1.FolderType();
            PatientIdType patient = createPatientIdType();
    
            TransactionSummaryType transaction = new TransactionSummaryType();
            AuthorType author = createAuthor();
            transaction.setAuthor(author);
            CDTRANSACTION cdTransaction = new CDTRANSACTION();
            cdTransaction.setS(CDTRANSACTIONschemes.CD_TRANSACTION);
            cdTransaction.setSV("1.0");
            cdTransaction.setValue("sumehr");
            transaction.getCds().add(cdTransaction);
            transaction.setDate(new org.joda.time.DateTime());
            transaction.getIds().add(createIdKmehr());
            transaction.setIscomplete(true);
            transaction.setIsvalidated(true);
            transaction.setTime(new org.joda.time.DateTime());
            transaction.setRecorddatetime(new org.joda.time.DateTime());
            transaction.getCds().add(cdTransaction);
            transaction.setDate(new org.joda.time.DateTime());
            transaction.getIds().add(createIdKmehr());
            transaction.setIscomplete(true);
            transaction.setIsvalidated(true);
            transaction.setTime(new org.joda.time.DateTime());
            transaction.setRecorddatetime(new org.joda.time.DateTime());
            folder.setTransaction(transaction);
            folder.setPatient(patient);
            kmehrHeader.setFolder(folder);
            hubServiceComplete.declareTransaction(kmehrHeader);
        }
            
                     	
        [Test]
        public void _17_requestPublication() {
            hubServiceComplete.requestPublication(createPatientIdType(), createTransactionWithPeriodType(), "");
        }
                    	    
        [Test]
        public void _18_putHcParty() {
            hubServiceComplete.putHCParty(createHcPartyAdaptedType());
        }
        
                            	    
        [Test]
	    public void _19_getHcParty() {
	        HCPartyIdType hcParty = createHcParty();
	        hubServiceComplete.getHCParty(hcParty);
	    } 
	                               	    
	                               	    
        [Test]
        public void _20_revokeHcPartyConsent() {
            ConsentHCPartyType consent = new ConsentHCPartyType();
            consent.setAuthor(createAuthor());
            consent.setHcparty(createHcParty());
            consent.setRevokedate(new org.joda.time.DateTime());
            consent.setSigndate(new org.joda.time.DateTime());
            hubServiceComplete.revokeHCPartyConsent(consent);
        }
	
	
        [Test]
        public void _21_putAccessRight() {
            AccessRightType accessRight = new AccessRightType();
            CDACCESSRIGHT cdAccessRight = new CDACCESSRIGHT();
            cdAccessRight.setS(CDACCESSRIGHTschemes.CD_ACCESSRIGHT);
            cdAccessRight.setSV("1.0");
            cdAccessRight.setValue(CDACCESSRIGHTvalues.ALLOW);
            accessRight.setCd(cdAccessRight);
            be.fgov.ehealth.hubservices.core.v1.HcpartyType hcParty = new be.fgov.ehealth.hubservices.core.v1.HcpartyType();
            hcParty.getCds().add(createCDHCPARTY());
            hcParty.getIds().add(createIDHCPARTY());
            accessRight.setHcparty(hcParty);
            TransactionIdType transaction = createTransactionIdType();
            accessRight.setTransaction(transaction);
            hubServiceComplete.putAccessRight(accessRight);
        }
        	   
        [Test]
        public void _22_getAccessRight() {
            TransactionIdType transaction = new TransactionIdType();
            IDKMEHR id = createIdKmehr();
            transaction.getIds().add(id);
            hubServiceComplete.getAccessRight(transaction);
        }
	
	
	    [Test]
	    public void _23_revokeAccessRight() {
	        SelectRevokeAccessRightType accessRight = new SelectRevokeAccessRightType();
	        be.fgov.ehealth.hubservices.core.v1.HcpartyType hcParty = new be.fgov.ehealth.hubservices.core.v1.HcpartyType();
	        hcParty.getCds().add(createCDHCPARTY());
	        hcParty.getIds().add(createIDHCPARTY());
	        accessRight.setHcparty(hcParty);
	        accessRight.setTransaction(createTransactionIdType());
	        hubServiceComplete.revokeAccessRight(accessRight);
	    }
	        	    
	    
        /**
         * Create an IDPATIENT for Niss
         */
        private static IDPATIENT createIdPatientInss() {
            IDPATIENT idPatient = new IDPATIENT();
            idPatient.setS(IDPATIENTschemes.INSS);
            idPatient.setSV("1.0");
            idPatient.setValue(PATIENT_INSS);
            return idPatient;
        }
    
        /**
         * Create an IDPATIENT for Niss
         */
        private static IDPATIENT createIdPatientCardno() {
            IDPATIENT idPatient = new IDPATIENT();
            idPatient.setS(IDPATIENTschemes.EID_CARDNO);
            idPatient.setSV("1.0");
            idPatient.setValue(PATIENT_CARDNO);
            return idPatient;
        }
    
        /**
         * Create an IDHCPARTY for Niss
         */
        private static IDHCPARTY createIdHcPartyNiss(String value) {
            IDHCPARTY idHcparty = new IDHCPARTY();
            idHcparty.setS(IDHCPARTYschemes.INSS);
            idHcparty.setSV("1.0");
            idHcparty.setValue(value);
            return idHcparty;
        }
    
        /**
         * Create an IDHCPARTY for Nihii
         */
        private static IDHCPARTY createIdHcPartyNihii() {
            IDHCPARTY idHcparty = new IDHCPARTY();
            idHcparty.setS(IDHCPARTYschemes.ID_HCPARTY);
            idHcparty.setSV("1.0");
            idHcparty.setValue(SessionUtil.getNihii11());
            return idHcparty;
        }
    
        /**
         * Create an IDKMEHR with the specified value
         */
        private static IDKMEHR createMessageId(String value) {
            IDKMEHR id = new IDKMEHR();
            id.setS(IDKMEHRschemes.ID_KMEHR);
            id.setSV("1.0");
            id.setValue(value);
            return id;
        }
    
        /**
         * Create a HcPartyId with the informations of the professional
         */
        private static HCPartyIdType createHcPartyIdProfessional() {
            HCPartyIdType hcParty = new HCPartyIdType();
            IDHCPARTY idHcparty = createIdHcPartyNihii();
            hcParty.getIds().add(idHcparty);
            idHcparty = createIdHcPartyNiss(PROF_INSS);
            hcParty.getIds().add(idHcparty);
            return hcParty;
        }
    
        /**
         * Create the professional HcParty
         */
        private static be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType createHcPartyProfessional() {
            be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType hcParty = new be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType();
            hcParty.setFamilyname(PROF_LASTNAME);
            hcParty.setFirstname(PROF_FIRSTNAME);
            CDHCPARTY cdHcParty = createCdHcPartyProfession();
            hcParty.getCds().add(cdHcParty);
            IDHCPARTY idHcparty = createIdHcPartyNiss(PROF_INSS);
            hcParty.getIds().add(idHcparty);
            return hcParty;
        }
    
        /**
         * Create a PatientIdType Used by createConsentType
         */
        private static PatientIdType createPatientIdType() {
            PatientIdType patient = new PatientIdType();
            IDPATIENT idPatient = createIdPatientInss();
            IDPATIENT idPatientCardNo = createIdPatientCardno();
            patient.getIds().add(idPatient);
            patient.getIds().add(idPatientCardNo);
            return patient;
        }
    
        /**
         * Create a cd with the profession in it Used by createHcPartyProfessional
         */
        private static CDHCPARTY createCdHcPartyProfession() {
            CDHCPARTY cdHcParty = new CDHCPARTY();
            cdHcParty.setS(CDHCPARTYschemes.CD_HCPARTY);
            cdHcParty.setSV("1.0");
            cdHcParty.setValue(PROF_PROFESSION);
            return cdHcParty;
        }
    
        /**
         * Create the header of the transaction
         */
        private static HeaderType createHeader() {
            HeaderType header = new HeaderType();
    
            StandardType standard = new StandardType();
            CDSTANDARD cd = new CDSTANDARD();
            cd.setSV("1.4");
            cd.setValue("20110701");
            cd.setS("CD-STANDARD");
            standard.setCd(cd);
    
            header.setStandard(standard);
            header.getIds().add(createMessageId(SessionUtil.getNihii11() + "." + IdGeneratorFactory.getIdGenerator().generateId()));
            org.joda.time.DateTime now = new org.joda.time.DateTime();
            header.setDate(now);
            header.setTime(now);
            header.getRecipients().add(createHub());
            header.setSender(createSender());
            return header;
        }
    
        /**
         * Create the author of the operation
         */
        private static SenderType createSender() {
            be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType hcParty = new be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType();
    
            IDHCPARTY doctorNISS = new IDHCPARTY();
            IDHCPARTY doctorNIHII = new IDHCPARTY();
            CDHCPARTY hcPartytype = new CDHCPARTY();
    
            doctorNIHII.setS(IDHCPARTYschemes.ID_HCPARTY);
            doctorNIHII.setSV("1.0");
            doctorNIHII.setValue(SessionUtil.getNihii());
    
            doctorNISS.setS(IDHCPARTYschemes.INSS);
            doctorNISS.setSV("1.0");
            doctorNISS.setValue(PROF_INSS);
    
            hcPartytype.setS(CDHCPARTYschemes.CD_HCPARTY);
            hcPartytype.setSV("1.0");
            hcPartytype.setValue(PROF_PROFESSION);
    
            hcParty.getIds().add(doctorNIHII);
            hcParty.getIds().add(doctorNISS);
            hcParty.getCds().add(hcPartytype);
    
            hcParty.setFamilyname(PROF_LASTNAME);
            hcParty.setFirstname(PROF_FIRSTNAME);
    
            SenderType sender = new SenderType();
            sender.getHcparties().add(hcParty);
    
            return sender;
        }
    
        /**
         * Create the author of the operation
         */
        private static AuthorType createAuthor() {
            AuthorType author = new AuthorType();
            be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType hcParty = createHcPartyProfessional();
            author.getHcparties().add(hcParty);
            return author;
        }
    
        /**
         * Create the Hub of the operation
         */
        private static RecipientType createHub() {
            be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType hub = new be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType();
    
            IDHCPARTY id = new IDHCPARTY();
            id.setValue(HUBID_RSW);
            id.setS(IDHCPARTYschemes.ID_HCPARTY);
            id.setSV("1.0");
            hub.getIds().add(id);
    
            CDHCPARTY cd = new CDHCPARTY();
            cd.setValue("hub");
            cd.setSV("1.0");
            cd.setS(CDHCPARTYschemes.CD_HCPARTY);
            hub.getCds().add(cd);
    
            hub.setName(HUB_NAME);
            RecipientType rec = new RecipientType();
            rec.getHcparties().add(hub);
            return rec;
        }
    
        /**
         * Create a consentType used for consent operations
         */
        private static ConsentType createConsentType() {
            ConsentType consent = new ConsentType();
    
            CDCONSENT cdConsent = new CDCONSENT();
            cdConsent.setS(CDCONSENTschemes.CD_CONSENTTYPE);
            cdConsent.setSV("1.0");
            cdConsent.setValue(CDCONSENTvalues.RETROSPECTIVE);
            consent.getCds().add(cdConsent);
    
            consent.setAuthor(createAuthor());
            consent.setPatient(createPatientIdType());
            consent.setSigndate(new org.joda.time.DateTime());
    
            return consent;
        }
    
        /**
         * Create a TherapeuticLinkType used for ther link operations
         */
        private static TherapeuticLinkType createTherapeuticLinkType() {
            TherapeuticLinkType therapeuticLink = new TherapeuticLinkType();
    
            CDTHERAPEUTICLINK cdTherLink = new CDTHERAPEUTICLINK();
            cdTherLink.setS(CDTHERAPEUTICLINKschemes.CD_THERAPEUTICLINKTYPE);
            cdTherLink.setSV("1.0");
            cdTherLink.setValue("gpconsultation");
            therapeuticLink.setCd(cdTherLink);
    
            therapeuticLink.setHcparty(createHcPartyIdProfessional());
            therapeuticLink.setPatient(createPatientIdType());
            therapeuticLink.setStartdate(new org.joda.time.DateTime());
            return therapeuticLink;
        }
    
        private static TransactionType createTransactionType() {
            return createTransactionType(IdGeneratorFactory.getIdGenerator(IdGeneratorFactory.UUID).generateId());
        }
    
        /**
         * Create a transaction type needed for transaction operations
         */
        private static TransactionType createTransactionType(String transactionId) {
            TransactionType transaction = (TransactionType) new MarshallerHelper(typeof(TransactionType), typeof(TransactionType)).toObject(
                    "<transaction xmlns='http://www.ehealth.fgov.be/standards/kmehr/schema/v1'><id S='ID-KMEHR' SV='1.0'>1</id><cd S='CD-TRANSACTION' SV='1.4'>sumehr</cd><date>2013-07-17</date><time>10:01:51+01:00</time><iscomplete>true</iscomplete><isvalidated>true</isvalidated><item><id S='ID-KMEHR' SV='1.0'>1</id><cd S='CD-ITEM' SV='1.4'>risk</cd><content><text L='fr'>travail sur écran</text></content><beginmoment><date>2013-06-21</date><time>14:51:24+01:00</time></beginmoment><recorddatetime>2013-06-21T14:53:28+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>2</id><cd S='CD-ITEM' SV='1.4'>adr</cd><content><text L='fr'>Ticlopidine</text></content><beginmoment><date>2013-06-21</date><time>14:51:24+01:00</time></beginmoment><recorddatetime>2013-06-21T14:52:34+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>3</id><cd S='CD-ITEM' SV='1.4'>medication</cd><content><cd S='CD-ATC' SV='1.0'>B01AC05</cd></content><content><text L='fr'>Ticlid (c) 250mg - 30 compr. enrobé(s)</text></content><content><medicinalproduct><intendedcd S='CD-DRUG-CNK' SV='2.0'>0857995</intendedcd><intendedname>Ticlid (c) 250mg - 30 compr. enrobé(s)</intendedname></medicinalproduct></content><beginmoment><date>2013-06-21</date></beginmoment><lifecycle><cd S='CD-LIFECYCLE' SV='1.3'>prescribed</cd></lifecycle><isrelevant>true</isrelevant><temporality><cd S='CD-TEMPORALITY' SV='1.0'>chronic</cd></temporality><quantity><decimal>1</decimal><unit><cd S='CD-UNIT' SV='1.3'>pkg</cd></unit></quantity><instructionforpatient L='fr'>1 compr. enrobé(s) 1 x / jour</instructionforpatient><recorddatetime>2013-06-21T14:51:24+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>4</id><cd S='CD-ITEM' SV='1.4'>medication</cd><content><cd S='CD-ATC' SV='1.0'>C10AA07</cd></content><content><text L='fr'>rosuvastatine 40 mg - 98 compr. pelliculé(s)</text></content><content><medicinalproduct><intendedcd S='CD-DRUG-CNK' SV='2.0'>2055176</intendedcd><intendedname>rosuvastatine 40 mg - 98 compr. pelliculé(s)</intendedname></medicinalproduct></content><beginmoment><date>2013-06-21</date></beginmoment><endmoment><date>2013-09-27</date></endmoment><lifecycle><cd S='CD-LIFECYCLE' SV='1.3'>prescribed</cd></lifecycle><isrelevant>true</isrelevant><temporality><cd S='CD-TEMPORALITY' SV='1.0'>acute</cd></temporality><quantity><decimal>1</decimal><unit><cd S='CD-UNIT' SV='1.3'>pkg</cd></unit></quantity><instructionforpatient L='fr'>1 compr. 1 x / jour</instructionforpatient><recorddatetime>2013-06-21T14:51:24+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>5</id><cd S='CD-ITEM' SV='1.4'>vaccine</cd><content><cd S='CD-VACCINEINDICATION' SV='1.0'>diphteria</cd><cd S='CD-VACCINEINDICATION' SV='1.0'>tetanus</cd><cd S='CD-ATC' SV='1.0'>J07AM51</cd></content><content><medicinalproduct><intendedcd S='CD-DRUG-CNK' SV='2.0'>1077593</intendedcd><intendedname>Tedivax pro adulto (c)</intendedname></medicinalproduct></content><beginmoment><date>2013-05-28</date></beginmoment><lifecycle><cd S='CD-LIFECYCLE' SV='1.3'>administrated</cd></lifecycle><recorddatetime>2013-06-21T14:53:34+02:00</recorddatetime></item><item><id S='ID-KMEHR' SV='1.0'>6</id><cd S='CD-ITEM' SV='1.4'>vaccine</cd><content><cd S='CD-VACCINEINDICATION' SV='1.0'>diphteria</cd><cd S='CD-VACCINEINDICATION' SV='1.0'>tetanus</cd><cd S='CD-VACCINEINDICATION' SV='1.0'>pertussis</cd><cd S='CD-VACCINEINDICATION' SV='1.0'>poliomyelitis</cd><cd S='CD-ATC' SV='1.0'>J07CA02</cd></content><content><medicinalproduct><intendedcd S='CD-DRUG-CNK' SV='2.0'>2374429</intendedcd><intendedname>Boostrix Polio (c)</intendedname></medicinalproduct></content><beginmoment><date>2013-05-28</date></beginmoment><lifecycle><cd S='CD-LIFECYCLE' SV='1.3'>administrated</cd></lifecycle><recorddatetime>2013-06-21T14:53:34+02:00</recorddatetime></item></transaction>");
    
            AuthorType author = new AuthorType();
            author.getHcparties().addAll(createSender().getHcparties());
    
            transaction.setAuthor(author);
            transaction.getIds().add(createMessageId("1"));
            transaction.getIds().add(createTransactionId(transactionId));
            return transaction;
        }
    
        /**
         * Create the transaction id with the specified value
         */
        private static IDKMEHR createTransactionId(String version) {
            IDKMEHR id = new IDKMEHR();
            id.setS(IDKMEHRschemes.LOCAL);
            id.setSL("EHBASICSOFT");
            id.setSV("3.4.0-beta-5");
            id.setValue(version);
            return id;
        }
    
        /**
         * Create the patient needed for some transaction
         */
        private static PersonType createPatientForTransaction() {
            PersonType patient = new PersonType();
            IDPATIENT kmehrPatientId = new IDPATIENT();
            kmehrPatientId.setS(IDPATIENTschemes.INSS);
            kmehrPatientId.setSV("1.0");
            kmehrPatientId.setValue(PATIENT_INSS);
            patient.getIds().add(kmehrPatientId);
            patient.getFirstnames().add(PATIENT_FIRSTNAME);
            patient.setFamilyname(PATIENT_LASTNAME);
            return patient;
        }
    
        /**
         * Create the patient needed for the putPatient operation
         */
        private static PersonType createPatient() {
            PersonType person = new PersonType();
            person.getFirstnames().add(PATIENT_FIRSTNAME);
            person.setFamilyname(PATIENT_LASTNAME);
            person.setRecorddatetime(new org.joda.time.DateTime());
            person.setUsuallanguage("fr");
    
            DateType dateType = new DateType();
            dateType.setDate(new org.joda.time.DateTime().withDayOfMonth(12).withMonthOfYear(12).withYear(1991));
            person.setBirthdate(dateType);
    
            Nationality nationality = new Nationality();
            CDCOUNTRY cdCountry = new CDCOUNTRY();
            cdCountry.setS(CDCOUNTRYschemes.CD_FED_COUNTRY);
            cdCountry.setSV("1.0");
            cdCountry.setValue("BE");
            nationality.setCd(cdCountry);
            person.setNationality(nationality);
    
            SexType sex = new SexType();
            CDSEX cdSex = new CDSEX();
            cdSex.setS("CD-SEX");
            cdSex.setSV("1.0");
            cdSex.setValue(CDSEXvalues.MALE);
            sex.setCd(cdSex);
            person.setSex(sex);
    
            person.getIds().add(createIdPatientInss());
            return person;
        }
            
        private IDKMEHR createIdKmehr() {
	        IDKMEHR id = new IDKMEHR();
	        id.setS(IDKMEHRschemes.ID_KMEHR);
	        id.setSV("1.0");
	        id.setValue("45454");
	        return id;
	    }
            
              private HCPartyIdType createHcParty() {
	        HCPartyIdType hcParty = new HCPartyIdType();
	        IDHCPARTY idHcparty = createIDHCPARTY();
	        hcParty.getIds().add(idHcparty);
	        return hcParty;
	    }
            
        private TransactionBaseType createTransaction() {
	        TransactionBaseType transaction = new TransactionBaseType();
	        AuthorType author = createAuthor();
	        transaction.setAuthor(author);
	        transaction.setId(createIdKmehr());
	        return transaction;
	    }
            
        private CDHCPARTY createCDHCPARTY() {
	        CDHCPARTY cdHcParty = new CDHCPARTY();
	        cdHcParty.setS(CDHCPARTYschemes.CD_HCPARTY);
	        cdHcParty.setSV("1.0");
	        cdHcParty.setValue(CDHCPARTYvalues.PERSPHYSICIAN.value());
	        return cdHcParty;
	    }

	    private HCPartyAdaptedType createHcPartyAdaptedType() {
	        HCPartyAdaptedType hcParty = new HCPartyAdaptedType();
	        hcParty.setFamilyname("De Clercq");
	        hcParty.setFirstname("Hannes");
	        CDHCPARTY cdHcParty = createCDHCPARTY();
	        hcParty.getCds().add(cdHcParty);
	        IDHCPARTY idHcparty = createIDHCPARTY();
	        hcParty.getIds().add(idHcparty);
	        hcParty.setRecorddatetime(new org.joda.time.DateTime());
	        hcParty.getAddresses().add(createAddress());
	        hcParty.getTelecoms().add(createTelecom());
	        return hcParty;
	    }

	    private be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType createHcpartyTypeComplete() {
	        be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType hcParty = new be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType();
	        hcParty.setFamilyname("De Clercq");
	        hcParty.setFirstname("Hannes");
	        CDHCPARTY cdHcParty = createCDHCPARTY();
	        hcParty.getCds().add(cdHcParty);
	        IDHCPARTY idHcparty = createIDHCPARTY();
	        hcParty.getIds().add(idHcparty);
	        return hcParty;
	    }

	   
	    private IDHCPARTY createIDHCPARTY() {
	        IDHCPARTY idHcparty = new IDHCPARTY();
	        idHcparty.setS(IDHCPARTYschemes.ID_HCPARTY);
	        idHcparty.setSV("1.0");
	        idHcparty.setValue(PATIENT_INSS);
	        return idHcparty;
	    }
            
	     private TransactionIdType createTransactionIdType() {
	        TransactionIdType transaction = new TransactionIdType();
	        transaction.getIds().add(createIdKmehr());
	        return transaction;
	    }
	    
        /**
         * Create a selectGetPatientConsentType used for consent operations
         */
        private SelectGetPatientConsentType createSelectGetPatientConsentType() {
            SelectGetPatientConsentType patientConsent = new SelectGetPatientConsentType();
    
            Consent selectConsent = new Consent();
            CDCONSENT cdConsent = new CDCONSENT();
            cdConsent.setS(CDCONSENTschemes.CD_CONSENTTYPE);
            cdConsent.setSV("1.0");
            cdConsent.setValue(CDCONSENTvalues.RETROSPECTIVE);
            selectConsent.getCds().add(cdConsent);
            patientConsent.setConsent(selectConsent);
    
            patientConsent.setPatient(createPatientIdType());
            return patientConsent;
        }

        /**
         * Create a SelectGetHCPartyPatientConsentType used for ther link operations
         */
        private SelectGetHCPartyPatientConsentType createSelectGetHCPartyPatientConsentType() {
            SelectGetHCPartyPatientConsentType selectConsent = new SelectGetHCPartyPatientConsentType();
    
            CDTHERAPEUTICLINK cdTherLink = new CDTHERAPEUTICLINK();
            cdTherLink.setS(CDTHERAPEUTICLINKschemes.CD_THERAPEUTICLINKTYPE);
            cdTherLink.setSV("1.0");
            cdTherLink.setValue("gpconsultation");
            selectConsent.getCds().add(cdTherLink);
    
            selectConsent.getPatientsAndHcparties().add(createPatientIdType());
            selectConsent.getPatientsAndHcparties().add(createHcPartyIdProfessional());
            selectConsent.setBegindate(new org.joda.time.DateTime());
            selectConsent.setEnddate(new org.joda.time.DateTime());
    
            return selectConsent;
        }
    
        private Kmehrmessage createTransactionForPut(){
            Kmehrmessage transaction = new Kmehrmessage();
            transaction.setHeader(createHeader());
    
            be.fgov.ehealth.standards.kmehr.schema.v1.FolderType folder = new be.fgov.ehealth.standards.kmehr.schema.v1.FolderType();
            folder.getIds().add(createMessageId("1"));
            folder.setPatient(createPatientForTransaction());
            folder.getTransactions().add(createTransactionType());
            transaction.getFolders().add(folder);
            return transaction;
        }
    
        private TransactionIdType createTransactionId() {
            TransactionIdType transid = new TransactionIdType();
            transid.getIds().add(createTransactionId(transactionId));
            return transid;
        }
    
        /**
         * Create a transactionWithPeriod type for transaction operations
         */
        private TransactionWithPeriodType createTransactionWithPeriodType() {
            TransactionWithPeriodType transaction = new TransactionWithPeriodType();
            transaction.setAuthor(createAuthor());
            transaction.setBegindate(new org.joda.time.DateTime());
            transaction.setEnddate(new org.joda.time.DateTime());
            return transaction;
        }
    
        /**
         * Create a transaction base type for transaction operations
         */
        private TransactionBaseType createTransactionBaseType() {
            TransactionBaseType transaction = new TransactionBaseType();
            transaction.setAuthor(createAuthor());
            transaction.setId(createTransactionId(transactionId));
            return transaction;
        }
        
        private AddressType createAddress() {
                AddressType address = new AddressType();
                address.setCity("");
                CDADDRESS cdAddress = new CDADDRESS();
                cdAddress.setS(CDADDRESSschemes.CD_ADDRESS);
                cdAddress.setSV("1.0");
                cdAddress.setValue("");
                address.getCds().add(cdAddress);
                CountryType country = new CountryType();
                CDCOUNTRY cdCountry = new CDCOUNTRY();
                cdCountry.setS(CDCOUNTRYschemes.CD_COUNTRY);
                cdCountry.setSV("1.0");
                cdCountry.setValue("");
                country.setCd(cdCountry);
                address.setCountry(country);
                address.setDistrict("");
                address.setHousenumber("");
                address.setNis("");
                address.setPostboxnumber("");
                address.setStreet("");
                address.setZip("");
                return address;
        }
        
         private TelecomType createTelecom() {
                TelecomType telecom = new TelecomType();
                telecom.setTelecomnumber("");
                CDTELECOM cdTelecom = new CDTELECOM();
                cdTelecom.setS(CDTELECOMschemes.CD_TELECOM);
                cdTelecom.setSV("1.0");
                cdTelecom.setValue("");
                telecom.getCds().add(cdTelecom);
                return telecom;
         }
           
	}
}
