/*
 * Copyright (c) eHealth
 */
package be.ehealth.technicalconnector.utils.impl;

import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

import be.ehealth.technicalconnector.service.etee.impl.ConnectorRevocationStatusChecker;
import be.ehealth.technicalconnector.service.sts.security.impl.KeyStoreCredential;
import be.fgov.ehealth.etee.crypto.status.CryptoResultException;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;


/**
 * Integration test for {@link OcspRevocationStatusChecker}.
 * 
 * @author EHP
 */
public class OcspRevocationStatusCheckerIntegrationTest {

 
    @ClassRule
    public static SessionRule rule = SessionRule.withInactiveSession().build();

    /**
     * Tests RevocationStatusChecker with keystore credential (from ehealth certificate)
     */
    @Test
    public void testWithKeyStoreCredential() throws Exception {
        String eHealthCertAlias = rule.getSessionProperty("test.keystore.alias");
        String eHealthCertificate = rule.getSessionProperty("test.keystore.location");
        String eHealthCertPassword = rule.getSessionProperty("test.keystore.password");

        ConnectorRevocationStatusChecker checker = new ConnectorRevocationStatusChecker();
        KeyStoreCredential credential = new KeyStoreCredential(eHealthCertificate, eHealthCertAlias, eHealthCertPassword);
        boolean isRevoked = checker.isRevoked(credential.getCertificate());
        Assert.assertFalse(isRevoked);
    }

}
