/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.utils.DateUtils;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class XSDDateTimeConverter {
    private static DateTimeFormatter basicDateFormatter = ISODateTimeFormat.date();

    private XSDDateTimeConverter() {
        throw new UnsupportedOperationException();
    }

    public static DateTime parseXSDDate(String text) {
        Calendar cal = DatatypeConverter.parseDate((String)text);
        return DateUtils.convert(cal);
    }

    public static String printXSDDate(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return basicDateFormatter.print((ReadableInstant)dateTime);
    }

    public static DateTime parseXSDTime(String text) {
        Calendar cal = DatatypeConverter.parseTime((String)text);
        return DateUtils.convert(cal);
    }

    public static String printXSDTime(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        Date date = dateTime.toDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return DatatypeConverter.printTime((Calendar)cal);
    }

    public static DateTime parseXSDDateTime(String text) {
        Calendar cal = DatatypeConverter.parseDateTime((String)text);
        return DateUtils.convert(cal);
    }

    public static String printXSDDateTime(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        Date date = dateTime.toDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return DatatypeConverter.printDateTime((Calendar)cal);
    }
}

