/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler;

import be.ehealth.technicalconnector.config.domain.Duration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.AbstractSOAPHandler;
import be.ehealth.technicalconnector.handler.utils.WSSecurityCrypto;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.SOAPConstants;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractWsSecurityHandler
extends AbstractSOAPHandler {
    public WSSecHeaderGeneratorStep0 buildSignature() throws WSSecurityException {
        return new WSSecHeaderGeneratorImpl();
    }

    @Override
    public boolean handleOutbound(SOAPMessageContext context) {
        try {
            this.getLogger().debug("adding WS-Security header");
            this.addWSSecurity(context);
            context.getMessage().saveChanges();
        }
        catch (Exception e) {
            throw new ProtocolException((Throwable)e);
        }
        return true;
    }

    protected abstract void addWSSecurity(SOAPMessageContext var1) throws IOException, WSSecurityException, TechnicalConnectorException, WSSecurityException;

    protected abstract Logger getLogger();

    private static class WSSecHeaderGeneratorImpl
    implements WSSecHeaderGeneratorStep0,
    WSSecHeaderGeneratorStep1,
    WSSecHeaderGeneratorStep2,
    WSSecHeaderGeneratorStep3,
    WSSecHeaderGeneratorStep4 {
        private SOAPPart soapPart;
        private WSSecHeader wsSecHeader;
        private WSSecSignature sign;
        private WSSecTimestamp wsSecTimeStamp;
        private String assertionId;
        private Credential cred;

        private WSSecHeaderGeneratorImpl() {
        }

        @Override
        public WSSecHeaderGeneratorStep1 on(SOAPMessage message) throws WSSecurityException {
            Validate.notNull((Object)message);
            this.soapPart = message.getSOAPPart();
            this.wsSecHeader = new WSSecHeader();
            this.wsSecHeader.insertSecurityHeader((Document)this.soapPart);
            WSSConfig wssConfig = WSSConfig.getNewInstance();
            wssConfig.setAddInclusivePrefixes(false);
            this.sign = new WSSecSignature(wssConfig);
            return this;
        }

        @Override
        public WSSecHeaderGeneratorStep2 withTimeStamp(long ttl, TimeUnit unit) {
            this.withTimeStamp(new Duration(ttl, unit));
            return this;
        }

        @Override
        public WSSecHeaderGeneratorStep2 withTimeStamp(Duration duration) {
            this.wsSecTimeStamp = new WSSecTimestamp();
            this.wsSecTimeStamp.setTimeToLive((int)duration.convert(TimeUnit.SECONDS));
            this.wsSecTimeStamp.build((Document)this.soapPart, this.wsSecHeader);
            return this;
        }

        @Override
        public WSSecHeaderGeneratorStep3 withBinarySecurityToken(Credential cred) throws TechnicalConnectorException, WSSecurityException {
            this.cred = cred;
            return this;
        }

        @Override
        public WSSecHeaderGeneratorStep3 withSAMLToken(SAMLToken token) throws WSSecurityException, TechnicalConnectorException {
            this.cred = token;
            Element assertionElement = token.getAssertion();
            Element importedAssertionElement = (Element)this.soapPart.importNode((Node)assertionElement, true);
            Element securityHeaderElement = this.wsSecHeader.getSecurityHeader();
            securityHeaderElement.appendChild(importedAssertionElement);
            this.assertionId = assertionElement.getAttribute("AssertionID");
            return this;
        }

        @Override
        public void sign(SignedParts ... parts) throws WSSecurityException, TechnicalConnectorException {
            if (StringUtils.isNotEmpty((String)this.assertionId)) {
                this.sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
                this.sign.setKeyIdentifierType(12);
                this.sign.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                this.sign.setCustomTokenId(this.assertionId);
            } else {
                this.sign.setKeyIdentifierType(1);
            }
            WSSecurityCrypto crypto = new WSSecurityCrypto(this.cred.getPrivateKey(), this.cred.getCertificate());
            this.sign.prepare((Document)this.soapPart, (Crypto)crypto, this.wsSecHeader);
            if (StringUtils.isEmpty((String)this.assertionId)) {
                this.sign.appendBSTElementToHeader(this.wsSecHeader);
            }
            List referenceList = this.sign.addReferencesToSign(this.generateReferencesToSign(parts), this.wsSecHeader);
            this.sign.computeSignature(referenceList, false, null);
        }

        protected List<WSEncryptionPart> generateReferencesToSign(SignedParts[] parts) {
            ArrayList<WSEncryptionPart> signParts = new ArrayList<WSEncryptionPart>();
            block6: for (SignedParts part : parts) {
                switch (part) {
                    case TIMESTAMP: {
                        Validate.notNull((Object)this.wsSecTimeStamp);
                        signParts.add(new WSEncryptionPart(this.wsSecTimeStamp.getId()));
                        continue block6;
                    }
                    case BODY: {
                        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)this.soapPart.getDocumentElement());
                        signParts.add(new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content"));
                        continue block6;
                    }
                    case SAML_ASSERTION: {
                        Validate.notNull((Object)this.assertionId);
                        signParts.add(new WSEncryptionPart(this.assertionId));
                        continue block6;
                    }
                    case BST: {
                        signParts.add(new WSEncryptionPart(this.sign.getBSTTokenId()));
                        continue block6;
                    }
                }
            }
            return signParts;
        }
    }

    public static interface WSSecHeaderGeneratorStep4 {
        public void sign(SignedParts ... var1) throws WSSecurityException, TechnicalConnectorException;
    }

    public static interface WSSecHeaderGeneratorStep3
    extends WSSecHeaderGeneratorStep4 {
        public WSSecHeaderGeneratorStep3 withSAMLToken(SAMLToken var1) throws WSSecurityException, TechnicalConnectorException;
    }

    public static interface WSSecHeaderGeneratorStep2
    extends WSSecHeaderGeneratorStep3 {
        public WSSecHeaderGeneratorStep3 withBinarySecurityToken(Credential var1) throws TechnicalConnectorException, WSSecurityException;
    }

    public static interface WSSecHeaderGeneratorStep1
    extends WSSecHeaderGeneratorStep2 {
        public WSSecHeaderGeneratorStep2 withTimeStamp(long var1, TimeUnit var3);

        public WSSecHeaderGeneratorStep2 withTimeStamp(Duration var1);
    }

    public static interface WSSecHeaderGeneratorStep0
    extends WSSecHeaderGeneratorStep2 {
        public WSSecHeaderGeneratorStep1 on(SOAPMessage var1) throws WSSecurityException;
    }

    protected static enum SignedParts {
        BODY,
        TIMESTAMP,
        BST,
        SAML_ASSERTION;

    }
}

