/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.domain.Duration;
import be.ehealth.technicalconnector.config.impl.ConfigurationModuleLoader;
import be.ehealth.technicalconnector.config.impl.RecursiveProperties;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationImpl
implements Configuration {
    public static final String SYSPROP_MODULE_LOADING = "be.ehealth.technicalconnector.config.modules.load";
    private static final String DURATION = ".duration";
    private static final String TIMEUNIT = ".timeunit";
    private static volatile ConfigurationImpl instance;
    private static final Logger LOG;
    private Properties properties;

    private ConfigurationImpl() {
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    @Override
    public Long getLongProperty(String key, Long defaultValue) {
        return Long.valueOf(this.getProperty(key, "" + defaultValue));
    }

    @Override
    public Integer getIntegerProperty(String key, Integer defaultValue) {
        return Integer.valueOf(this.getProperty(key, "" + defaultValue));
    }

    @Override
    public Boolean getBooleanProperty(String key, Boolean defaultValue) {
        return Boolean.valueOf(this.getProperty(key, "" + defaultValue));
    }

    @Override
    public Duration getDurationProperty(String key, Long defaultValue, TimeUnit defaultTimeUnit) {
        long duration = this.getLongProperty(key + DURATION, defaultValue);
        String timeUnit = this.getProperty(key + TIMEUNIT, defaultTimeUnit.name());
        return new Duration(duration, TimeUnit.valueOf(timeUnit));
    }

    @Override
    public boolean hasDurationProperty(String key) {
        return this.hasProperty(key + DURATION) && this.hasProperty(key + TIMEUNIT);
    }

    @Override
    public URL getURLProperty(String key) {
        String wsdl = this.getProperty(key);
        try {
            return new URL(wsdl);
        }
        catch (MalformedURLException e) {
            LOG.error("No valid url: " + wsdl);
            return null;
        }
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public static synchronized void reset() {
        instance = null;
    }

    @Override
    public void reload() throws TechnicalConnectorException {
        if (instance == null) {
            throw new IllegalStateException("reload called while instance is not initialized");
        }
        ConfigurationModuleLoader.load(instance);
    }

    @Override
    public boolean containsKey(String key) {
        return this.hasProperty(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.init();
        if (!StringUtils.isEmpty((String)key)) {
            this.properties.remove(key);
            if (!StringUtils.isEmpty((String)value)) {
                this.properties.put(key, value);
            }
        }
    }

    private void init() {
        if (this.properties == null) {
            this.properties = new RecursiveProperties();
            try {
                this.load(ConfigFactory.getConfigLocation(), this.properties);
            }
            catch (TechnicalConnectorException e) {
                LOG.error("Loading properties failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void load(String file, Properties props) {
        InputStream is;
        block10: {
            is = null;
            try {
                block9: {
                    LOG.info("Trying to load properties: " + file);
                    try {
                        is = ConnectorIOUtils.getResourceAsStream(file);
                    }
                    catch (TechnicalConnectorException e) {
                        if (!"/be.ehealth.technicalconnector.properties".equals(file)) break block9;
                        String moddedFile = "./" + file;
                        LOG.info("Trying to load properties: " + file);
                        is = ConnectorIOUtils.getResourceAsStream(moddedFile);
                    }
                }
                if (is != null) {
                    props.load(is);
                    break block10;
                }
                LOG.error("Loading properties failed: " + file);
            }
            catch (TechnicalConnectorException e) {
                LOG.error("Loading properties failed: " + file, (Throwable)e);
                ConnectorIOUtils.closeQuietly((Object)is);
            }
            catch (IOException e2) {
                LOG.error("Loading properties failed: " + file, (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        ConnectorIOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
                ConnectorIOUtils.closeQuietly((Object)is);
            }
        }
        ConnectorIOUtils.closeQuietly((Object)is);
    }

    @Override
    public boolean hasProperty(String key) {
        this.init();
        return this.properties != null && this.properties.containsKey(key);
    }

    @Override
    public boolean hasMatchingProperty(String rootKey) {
        String key = rootKey + "." + 1;
        return this.hasProperty(key);
    }

    @Override
    public List<String> getMatchingProperties(String rootKey) {
        this.init();
        int i = 1;
        ArrayList<String> ret = new ArrayList<String>();
        String key;
        while (this.hasProperty(key = rootKey + "." + i)) {
            ret.add(this.getProperty(key));
            ++i;
        }
        return ret;
    }

    @Override
    @Deprecated
    public void setConfigLocation(String location) throws TechnicalConnectorException {
        ConfigFactory.setConfigLocation(location);
    }

    @Override
    public Configuration getCurrentConfig() throws TechnicalConnectorException {
        return ConfigurationImpl.getInstance();
    }

    public static synchronized Configuration getInstance() throws TechnicalConnectorException {
        if (instance == null) {
            instance = new ConfigurationImpl();
            if ("true".equals(System.getProperty(SYSPROP_MODULE_LOADING, "true"))) {
                instance.reload();
            }
        }
        return instance;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void invalidate() {
        ConfigurationModuleLoader.unload();
    }

    static {
        LOG = LoggerFactory.getLogger(ConfigurationImpl.class);
    }
}

