/*
 * Copyright (c) eHealth
 */
package be.fgov.ehealth.technicalconnector.tests.session;

import java.io.File;
import java.io.FileWriter;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.service.ServiceFactory;
import be.ehealth.technicalconnector.service.keydepot.KeyDepotManagerFactory;
import be.ehealth.technicalconnector.service.kgss.KgssManager;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.validator.impl.TimeStampValidatorFactory;


/**
 * SessionDestroyer
 * 
 * @author EHP
 * 
 */
public class SessionDestroyer {

    private static final Logger LOG = LoggerFactory.getLogger(SessionDestroyer.class);

    public static void destroy() throws Exception {
        Session.setSessionManager(null);

        if (Session.getInstance().hasValidSession()) {
            Session.getInstance().unloadSession();
        }

        try {
            KeyDepotManagerFactory.getKeyDepotManager().setKeyDepotService(ServiceFactory.getKeyDepotService());
        } catch (Throwable e) {
            LOG.error(e.getMessage(), e);
        }
        try {
            KgssManager.getInstance().setKgssService(ServiceFactory.getKgssService());
        } catch (Throwable e) {
            LOG.error(e.getMessage(), e);
        }
        
        TimeStampValidatorFactory.reset();
        
        ConfigFactory.invalidate();
        Properties reset = new Properties();
        File tempProp = File.createTempFile("SessionDestroyer", ".properties");
        tempProp.deleteOnExit();
        reset.store(new FileWriter(tempProp), "empty");
        ConfigFactory.setConfigLocation(tempProp.getAbsolutePath());
    }

}
