/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.utils;

import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Iterables {
    private Iterables() {
    }

    public static <T> List<T> newList() {
        return new ArrayList();
    }

    public static <T> List<T> newList(T ... items) {
        return new ArrayList<T>(Arrays.asList(items));
    }

    public static <T> List<T> newImmutableList(List<? extends T> list) {
        return Collections.unmodifiableList(list);
    }

    public static <T> List<T> newImmutableList(T ... items) {
        List<T> list = Iterables.newList();
        for (T item : items) {
            list.add(Preconditions.checkNotNull(item, "You can't add null items to an immutable list"));
        }
        return Iterables.newImmutableList(list);
    }

    public static <T> Set<T> newSet() {
        return new HashSet();
    }

    public static <T> T first(Iterable<T> iterable) {
        return iterable.iterator().next();
    }
}

