/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.ra.utils;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.utils.ConnectorCryptoUtils;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.fgov.ehealth.technicalconnector.ra.domain.DistinguishedName;
import be.fgov.ehealth.technicalconnector.ra.utils.RaPropertiesLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.joda.time.DateTime;

public class CertificateUtils {
    private static final String PROVIDER = "BC";
    private static final CertificateFactory CF;

    public static KeyPair generateKeyPair() {
        String authKeyAlgorithm = RaPropertiesLoader.getProperty("authentication.key.algorithm");
        Integer authKeySize = Integer.parseInt(RaPropertiesLoader.getProperty("authentication.key.size", "0"));
        try {
            KeyPairGenerator kg = KeyPairGenerator.getInstance(authKeyAlgorithm);
            kg.initialize(authKeySize, new SecureRandom());
            return kg.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(authKeyAlgorithm + " key algorithm is unknown to the security provider", e);
        }
    }

    public static byte[] createCSR(DistinguishedName distingueshedName, KeyPair keyPair) {
        String csrSignatureAlgorithm = RaPropertiesLoader.getProperty("csr.signature.algorithm");
        try {
            X500Principal x500Principal = new X500Principal(distingueshedName.asNormalizedEhealthDN());
            JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(x500Principal, keyPair.getPublic());
            PKCS10CertificationRequest csr = csrBuilder.build(new JcaContentSignerBuilder(csrSignatureAlgorithm).setProvider((Provider)new BouncyCastleProvider()).build(keyPair.getPrivate()));
            return csr.getEncoded();
        }
        catch (OperatorCreationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static X509Certificate generateCert(PublicKey rqPubKey, BigInteger serialNr, Credential cred) throws TechnicalConnectorException {
        try {
            X509Certificate cert = cred.getCertificate();
            X500Principal principal = cert.getSubjectX500Principal();
            Date notBefore = cert.getNotBefore();
            Date notAfter = cert.getNotAfter();
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(principal, serialNr, notBefore, notAfter, principal, rqPubKey);
            int keyUsageDetails = 16;
            builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(keyUsageDetails += 32));
            ContentSigner signer = new JcaContentSignerBuilder(cert.getSigAlgName()).build(cred.getPrivateKey());
            X509CertificateHolder holder = builder.build(signer);
            return new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(holder);
        }
        catch (OperatorCreationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static X509Certificate generateCert(KeyPair pair) {
        try {
            X500Principal principal = new X500Principal(RaPropertiesLoader.getProperty("dummycert.subject"));
            Date notBefore = new DateTime().minusDays(1).toDate();
            Date notAfter = new DateTime().minusDays(1).plusMinutes(1).toDate();
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(principal, new BigInteger("0"), notBefore, notAfter, principal, pair.getPublic());
            int keyUsageDetails = 16;
            builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(keyUsageDetails += 32));
            ContentSigner signer = new JcaContentSignerBuilder(RaPropertiesLoader.getProperty("dummycert.signature.algorithm")).build(pair.getPrivate());
            X509CertificateHolder holder = builder.build(signer);
            return new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(holder);
        }
        catch (OperatorCreationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static BigInteger obtainSerialNumber(PrivateKey key, byte[] challenge) throws TechnicalConnectorException {
        byte[] encryptedNonce = ArrayUtils.subarray((byte[])challenge, (int)0, (int)(challenge.length - 32));
        byte[] serialNrHashed = ArrayUtils.subarray((byte[])challenge, (int)(challenge.length - 32), (int)challenge.length);
        byte[] decryptedNonceBytes = ConnectorCryptoUtils.decrypt((Key)key, (String)RaPropertiesLoader.getProperty("etk.challenge.cipher"), (byte[])encryptedNonce);
        byte[] serialNr = ArrayUtils.subarray((byte[])decryptedNonceBytes, (int)0, (int)16);
        byte[] calculatedHash = ConnectorCryptoUtils.calculateDigest((String)RaPropertiesLoader.getProperty("etk.challenge.digest"), (byte[])serialNr);
        if (!Arrays.equals(serialNrHashed, calculatedHash)) {
            throw new IllegalArgumentException("The challenge is not valid because the hash of the decrypted serial nr found inside the challenge is not equal to the hashed serial nr attached to the challenge.");
        }
        byte[] serialNumberUnsigned = new byte[serialNr.length + 1];
        System.arraycopy(serialNr, 0, serialNumberUnsigned, 1, serialNr.length);
        return new BigInteger(serialNumberUnsigned);
    }

    public static X509Certificate toX509Certificate(byte[] cert) {
        X509Certificate x509Certificate;
        ByteArrayInputStream baos = null;
        try {
            baos = new ByteArrayInputStream(cert);
            x509Certificate = (X509Certificate)CF.generateCertificate(baos);
        }
        catch (CertificateException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                ConnectorIOUtils.closeQuietly(baos);
                throw throwable;
            }
        }
        ConnectorIOUtils.closeQuietly((Object)baos);
        return x509Certificate;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            CF = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

