/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.signature.impl.xades.impl;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPCheckerBuilder;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPData;
import be.fgov.ehealth.etee.crypto.policies.OCSPPolicy;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationResult;
import be.fgov.ehealth.technicalconnector.signature.impl.xades.XadesSpecification;
import be.fgov.ehealth.technicalconnector.signature.impl.xades.domain.SignedPropertiesBuilder;
import be.fgov.ehealth.technicalconnector.signature.impl.xades.domain.UnsignedPropertiesBuilder;
import java.io.IOException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.apache.xml.security.signature.XMLSignature;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.w3c.dom.Element;

public class XadesCSpecification
implements XadesSpecification {
    @Override
    public void addOptionalBeforeSignatureParts(SignedPropertiesBuilder signedProps, XMLSignature sig, Credential signing, String uuid, Map<String, Object> options) throws TechnicalConnectorException {
    }

    @Override
    public void addOptionalAfterSignatureParts(UnsignedPropertiesBuilder unsignedProps, XMLSignature sig, String uuid, Map<String, Object> options) throws TechnicalConnectorException {
        try {
            X509Certificate signing = sig.getKeyInfo().getX509Certificate();
            OCSPData ocsp = (OCSPData)OCSPCheckerBuilder.newBuilder().addOCSPPolicy(OCSPPolicy.RECEIVER_MANDATORY).build().validate(signing).getData();
            unsignedProps.addCertificate(signing);
            for (X509CRL crl : ocsp.getCrls()) {
                unsignedProps.addCrlRef(crl);
            }
            unsignedProps.addOCSPRef(this.convertToOCSPResp(ocsp));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] convertToOCSPResp(OCSPData data) throws IOException, OCSPException {
        BasicOCSPResp basicResp = new BasicOCSPResp(BasicOCSPResponse.getInstance((Object)ASN1Primitive.fromByteArray((byte[])data.getOcspResponse())));
        return new OCSPRespBuilder().build(0, (Object)basicResp).getEncoded();
    }

    @Override
    public void verify(SignatureVerificationResult result, Element sigElement) {
    }
}

