/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.signature.impl;

import be.ehealth.technicalconnector.exception.ConfigurationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.ExtendedCredential;
import be.fgov.ehealth.technicalconnector.signature.resolvers.SAMLAssertionKeyResolver;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Map;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignatureUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureUtils.class);
    private static final String JSR105PROVIDER_CLASSNAME_DEFAULT = "org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI";
    public static final String XMLNS_DS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String XMLNS_XADES_1_3_2 = "http://uri.etsi.org/01903/v1.3.2#";
    private static final CertificateFactory CF;
    private static XMLSignatureFactory fac;

    private SignatureUtils() {
        throw new UnsupportedOperationException();
    }

    public static XMLSignatureFactory getXMLSignatureFactory() {
        return fac;
    }

    public static <T> T getOption(String key, Map<String, Object> optionMap, T defaultValue) {
        Object result = defaultValue;
        if (optionMap.containsKey(key) && optionMap.get(key) != null) {
            result = optionMap.get(key);
        }
        LOG.info("Using the following " + key + ":" + result);
        return result;
    }

    public static MessageDigest getDigestInstance(String algorithmURI) throws NoSuchAlgorithmException {
        MessageDigest md;
        String algorithmID = JCEMapper.translateURItoJCEID((String)algorithmURI);
        if (algorithmID == null) {
            throw new NoSuchAlgorithmException("Could not translate algorithmURI [" + algorithmURI + "]");
        }
        String provider = JCEMapper.getProviderId();
        try {
            md = provider == null ? MessageDigest.getInstance(algorithmID) : MessageDigest.getInstance(algorithmID, provider);
        }
        catch (NoSuchProviderException ex) {
            throw new NoSuchAlgorithmException("Could not find provider for [" + algorithmID + "]", ex);
        }
        return md;
    }

    public static CertPath getCertPath(Credential cred) throws TechnicalConnectorException {
        if (cred instanceof ExtendedCredential) {
            return ((ExtendedCredential)cred).getCertPath();
        }
        try {
            return CF.generateCertPath(Arrays.asList(cred.getCertificateChain()));
        }
        catch (CertificateException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_IOEXCEPTION, (Throwable)e, new Object[0]);
        }
    }

    static {
        try {
            CF = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException e) {
            throw new IllegalArgumentException(e);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyResolver.register((KeyResolverSpi)new SAMLAssertionKeyResolver(), (boolean)true);
        try {
            String providerName = System.getProperty("jsr105Provider", JSR105PROVIDER_CLASSNAME_DEFAULT);
            LOG.info("Instantiating providate with class [" + providerName + "]");
            Provider provider = (Provider)Class.forName(JSR105PROVIDER_CLASSNAME_DEFAULT).newInstance();
            LOG.info("Using the following provider: " + provider + " " + provider.getInfo());
            fac = XMLSignatureFactory.getInstance("DOM", provider);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException((Exception)e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException((Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException((Exception)e);
        }
    }
}

