/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.ws.impl.strategy;

import be.ehealth.technicalconnector.exception.RetryNextEndpointException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.ehealth.technicalconnector.ws.impl.AbstractWsSender;
import be.ehealth.technicalconnector.ws.impl.strategy.InvokeStrategy;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoRetryInvokeStrategy
extends AbstractWsSender
implements InvokeStrategy {
    private static Logger LOG = LoggerFactory.getLogger(NoRetryInvokeStrategy.class);

    @Override
    public GenericResponse invoke(SOAPMessageContext request, Handler<?>[] chain) throws TechnicalConnectorException {
        try {
            return AbstractWsSender.call(request, chain);
        }
        catch (RetryNextEndpointException e) {
            Throwable reason = ExceptionUtils.getRootCause((Throwable)e);
            LOG.error("Cannot send SOAP message. Reason [" + reason + "]", (Throwable)e);
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, reason);
        }
    }
}

