/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils.impl;

import be.ehealth.technicalconnector.config.ConfigFactory;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.bouncycastle.util.encoders.Base64;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JaxbContextFactory {
    public static final String PROP_CACHE_TYPE = "be.ehealth.technicalconnector.utils.impl.JaxbContextFactory.cache_type";
    private static final String PROP_CACHE_TYPE_CLASSNAME = "classname";
    private static final String PROP_CACHE_TYPE_PACKAGE = "package";
    private static final String PROP_CACHE_TYPE_DEFAULT = "classname";
    private static final Logger LOG = LoggerFactory.getLogger(JaxbContextFactory.class);
    private static final Map<String, JAXBContext> CACHE = new HashMap<String, JAXBContext>();
    private static String cacheType = ConfigFactory.getConfigValidator().getProperty("be.ehealth.technicalconnector.utils.impl.JaxbContextFactory.cache_type", "classname");

    private JaxbContextFactory() {
        throw new UnsupportedOperationException();
    }

    public static void initJaxbContext(Class<?> ... classesToBeBound) {
        try {
            JaxbContextFactory.getJaxbContextForClass(classesToBeBound);
        }
        catch (JAXBException e) {
            LOG.warn("Unable to load JaxbContext for " + ArrayUtils.toString(classesToBeBound), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JAXBContext getJaxbContextForClass(Class<?> ... classesToBeBound) throws JAXBException {
        String key = null;
        String packageToBeBound = null;
        if (classesToBeBound.length == 1) {
            if (PROP_CACHE_TYPE_PACKAGE.equals(cacheType)) {
                packageToBeBound = key = classesToBeBound[0].getPackage().getName();
            } else {
                if (!"classname".equals(cacheType)) throw new IllegalArgumentException("Unsupported cachetype [" + cacheType + "]");
                key = classesToBeBound[0].getName();
            }
        } else {
            DateTime start = new DateTime();
            TreeSet<String> classList = new TreeSet<String>();
            for (Class<?> classToBeBound : classesToBeBound) {
                classList.add(classToBeBound.getName());
            }
            MessageDigest complete = DigestUtils.getMd5Digest();
            for (String clazz : classList) {
                complete.update(clazz.getBytes());
            }
            key = new String(Base64.encode((byte[])complete.digest()));
            LOG.debug("Calculating digest-key for " + ArrayUtils.toString(classesToBeBound) + " in " + new Duration((ReadableInstant)start, (ReadableInstant)new DateTime()));
        }
        JAXBContext context = CACHE.get(key);
        if (context != null) return context;
        DateTime start = new DateTime();
        context = packageToBeBound == null ? JAXBContext.newInstance((Class[])classesToBeBound) : JAXBContext.newInstance((String)packageToBeBound);
        LOG.debug("Creating new context for package: " + ArrayUtils.toString(classesToBeBound) + " in " + new Duration((ReadableInstant)start, (ReadableInstant)new DateTime()));
        CACHE.put(key, context);
        return context;
    }

    public static void reset() {
        CACHE.clear();
    }
}

