/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.utils;

import be.ehealth.technicalconnector.exception.InstantiationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ConnectorXmlUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorXmlUtils.class);
    private static final String XML_PATTERN_STR = "<(\\S+?)(.*?)>(.*?)</\\1>";

    private ConnectorXmlUtils() {
        throw new UnsupportedOperationException();
    }

    public static Element getFirstChildElement(Node node) {
        Node child;
        for (child = node.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        if (child != null) {
            return (Element)child;
        }
        return null;
    }

    @Deprecated
    public static void logXmlObject(Object obj) {
        ConnectorXmlUtils.dump(obj);
    }

    public static void dump(Object obj) {
        if (LOG.isDebugEnabled()) {
            try {
                if (obj != null) {
                    String xmlString = ConnectorXmlUtils.toString(obj);
                    LOG.debug("Contents of " + obj.getClass().getCanonicalName() + "  : " + xmlString + "");
                }
            }
            catch (Exception e) {
                LOG.error("Error occured while logging contents of object " + obj.getClass().getCanonicalName() + ". Reason: " + e.getMessage());
            }
        }
    }

    @Deprecated
    public static String marshal(Object obj) {
        return ConnectorXmlUtils.toString(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static byte[] toByteArray(Node node) {
        byte[] byArray;
        ByteArrayOutputStream out = null;
        try {
            DOMSource source = new DOMSource(node);
            out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            byArray = out.toByteArray();
        }
        catch (TransformerConfigurationException e) {
            LOG.error(e.getClass().getSimpleName() + ":" + e.getMessage());
            ConnectorIOUtils.closeQuietly((Object)out);
        }
        catch (TransformerException e2) {
            LOG.error(e2.getClass().getSimpleName() + ":" + e2.getMessage());
            {
                catch (Throwable throwable) {
                    ConnectorIOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            ConnectorIOUtils.closeQuietly((Object)out);
        }
        ConnectorIOUtils.closeQuietly((Object)out);
        return byArray;
        return null;
    }

    public static byte[] toByteArray(Object obj) {
        MarshallerHelper marshallerHelper = new MarshallerHelper(obj.getClass(), obj.getClass());
        return marshallerHelper.toXMLByteArray(obj);
    }

    @Deprecated
    public static byte[] toByteArray(Object data, QName rootTag) {
        MarshallerHelper marshaller = new MarshallerHelper(data.getClass(), data.getClass());
        return marshaller.toXMLByteArrayNoRootElementRequired(data);
    }

    public static Document toDocument(byte[] data) throws TechnicalConnectorException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(new ByteArrayInputStream(data));
        }
        catch (SAXException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
        catch (IOException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
    }

    public static Document toDocument(Object obj) {
        MarshallerHelper marshallerHelper = new MarshallerHelper(obj.getClass(), obj.getClass());
        return marshallerHelper.toDocument(obj);
    }

    public static Document toDocument(String xml) throws TechnicalConnectorException {
        if (!ConnectorXmlUtils.isXMLLike(xml)) {
            throw new IllegalArgumentException("Parameter xml doesn't contains a well-formed xml");
        }
        try {
            InputSource source = new InputSource(new StringReader(xml));
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            return builder.parse(source);
        }
        catch (IOException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
        catch (SAXException e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
    }

    public static Element toElement(byte[] data) throws TechnicalConnectorException {
        return ConnectorXmlUtils.toDocument(data).getDocumentElement();
    }

    public static String toString(Object obj) {
        MarshallerHelper marshallerHelper = new MarshallerHelper(obj.getClass(), obj.getClass());
        return marshallerHelper.toString(obj);
    }

    public static String toString(Node node) throws TechnicalConnectorException {
        return ConnectorXmlUtils.toString(new DOMSource(node));
    }

    public static String toString(Source source) throws TechnicalConnectorException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            TransformerFactory tff = TransformerFactory.newInstance();
            Transformer tf = tff.newTransformer();
            tf.setOutputProperty("omit-xml-declaration", "yes");
            StreamResult result = new StreamResult(outputStream);
            tf.transform(source, result);
            String string = new String(outputStream.toByteArray(), "UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_GENERAL, (Throwable)e, e.getMessage());
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)outputStream);
        }
    }

    public static String flatten(String xml) {
        String result = xml.replaceAll("[\t\n\r]", "");
        while (result.contains(" <")) {
            result = result.replace(" <", "<");
        }
        return result;
    }

    public static String format(String unformattedXml) {
        return ConnectorXmlUtils.format(unformattedXml, null);
    }

    public static String format(String unformattedXml, Source xslt) {
        if (!ConnectorXmlUtils.isXMLLike(unformattedXml)) {
            return unformattedXml;
        }
        try {
            Document doc = ConnectorXmlUtils.parseXmlFile(unformattedXml);
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = null;
            transformer = xslt != null ? tf.newTransformer(xslt) : tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(1));
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerConfigurationException e) {
            throw new InstantiationException(e);
        }
        catch (TransformerException e) {
            throw new InstantiationException(e);
        }
    }

    private static Document parseXmlFile(String in) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(in));
            return db.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw new InstantiationException(e);
        }
        catch (SAXException e) {
            throw new InstantiationException(e);
        }
        catch (IOException e) {
            throw new InstantiationException(e);
        }
    }

    private static boolean isXMLLike(String inXMLStr) {
        boolean retBool = false;
        if (inXMLStr != null && inXMLStr.trim().length() > 0 && inXMLStr.trim().startsWith("<")) {
            Pattern pattern = Pattern.compile(XML_PATTERN_STR, 42);
            Matcher matcher = pattern.matcher(inXMLStr.replaceFirst("<\\?xml.*?>", "").trim());
            retBool = matcher.matches();
        }
        return retBool;
    }
}

