/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.beid;

import be.ehealth.technicalconnector.beid.BeIDCardFactory;
import be.ehealth.technicalconnector.beid.domain.Address;
import be.ehealth.technicalconnector.beid.domain.Identity;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.ConfigValidator;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.mapper.Mapper;
import be.ehealth.technicalconnector.mapper.MapperFactory;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionServiceWithCache;
import be.fedict.commons.eid.client.BeIDCard;
import be.fedict.commons.eid.client.FileType;
import be.fedict.commons.eid.consumer.tlv.TlvParser;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeIDInfo
implements SessionServiceWithCache {
    public static final String PROP_USE_CACHE = "be.ehealth.technicalconnector.beid.beidinfo.cache";
    private static final boolean PROP_USE_CACHE_DEFAULT_VALUE = false;
    private static final Logger LOG = LoggerFactory.getLogger(BeIDInfo.class);
    private static Map<String, BeIDInfo> instancesMap = new HashMap<String, BeIDInfo>();
    private Address address;
    private Identity identity;
    private byte[] photo;
    private static Mapper mapper = MapperFactory.getMapper("dozer/commonseid.xml");
    private static ConfigValidator config = ConfigFactory.getConfigValidator();

    private BeIDInfo() throws TechnicalConnectorException {
        BeIDCard beIDCard = BeIDCardFactory.getBeIDCard();
        try {
            LOG.debug("processing identity file");
            byte[] identityFile = beIDCard.readFile(FileType.Identity);
            be.fedict.commons.eid.consumer.Identity identityFedict = (be.fedict.commons.eid.consumer.Identity)TlvParser.parse((byte[])identityFile, be.fedict.commons.eid.consumer.Identity.class);
            this.identity = mapper.map(identityFedict, Identity.class);
            LOG.debug("processing address file");
            byte[] addressFile = beIDCard.readFile(FileType.Address);
            be.fedict.commons.eid.consumer.Address addressFedict = (be.fedict.commons.eid.consumer.Address)TlvParser.parse((byte[])addressFile, be.fedict.commons.eid.consumer.Address.class);
            this.address = mapper.map(addressFedict, Address.class);
            LOG.debug("processing photo file");
            this.photo = beIDCard.readFile(FileType.Photo);
        }
        catch (Exception e) {
            throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.BEID_ERROR, (Throwable)e, e.getMessage());
        }
        beIDCard.close();
        Session.getInstance().registerSessionService(this);
    }

    public static BeIDInfo getInstance() throws TechnicalConnectorException {
        return BeIDInfo.getInstance("DEFAULT", false);
    }

    public static BeIDInfo getInstance(String scope) throws TechnicalConnectorException {
        boolean useCache = config.getBooleanProperty(PROP_USE_CACHE, false);
        return BeIDInfo.getInstance(scope, useCache);
    }

    public static BeIDInfo getInstance(String scope, boolean useCache) throws TechnicalConnectorException {
        if (useCache && instancesMap.containsKey(scope)) {
            LOG.debug("Returning cached instance.");
            return instancesMap.get(scope);
        }
        BeIDInfo result = new BeIDInfo();
        if (useCache) {
            instancesMap.put(scope, result);
        }
        return result;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Address getAddress() {
        return this.address;
    }

    public byte[] getPhoto() throws TechnicalConnectorException {
        return ArrayUtils.clone((byte[])this.photo);
    }

    @Override
    public void flushCache() {
        instancesMap.clear();
    }
}

