/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.genins.service;

import be.ehealth.businessconnector.genins.exception.GenInsBusinessConnectorException;
import be.ehealth.businessconnector.genins.service.GenInsService;
import be.ehealth.businessconnector.genins.service.impl.GenInsServiceImpl;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.handler.soap.SOAPHandler;

public final class ServiceFactory {
    private static List<String> expectedProps = new ArrayList<String>();
    private static final String PROP_ENDPOINT_GENINS_V1 = "endpoint.genins";
    private static final String PROP_VALIDATION_INCOMING_GENINS = "validation.incoming.genins.message";
    private static final String GENINS_PROT = "/ehealth-mycarenet-genins/XSD/ehealth-genins-protocol-1_1.xsd";
    private static GenInsService service;
    private static Configuration config;
    public static final String[] GENINS_XSD;

    private ServiceFactory() {
        throw new UnsupportedOperationException();
    }

    public static GenInsService getGeninsService() {
        if (service == null) {
            service = new GenInsServiceImpl();
        }
        return service;
    }

    public static GenericRequest getGeninsPort(SAMLToken token) throws MalformedURLException, TechnicalConnectorException, GenInsBusinessConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_GENINS_V1));
        genReq.setCredential((Credential)token, TokenType.SAML);
        HandlerChain chain = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_GENINS))) {
            chain.register(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, GENINS_XSD));
        } else {
            chain.register(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, GENINS_XSD));
        }
        genReq.setDefaultHandlerChain();
        genReq.setHandlerChain(chain);
        return genReq;
    }

    static {
        GENINS_XSD = new String[]{GENINS_PROT};
        expectedProps.add(PROP_ENDPOINT_GENINS_V1);
        config = ConfigFactory.getConfigValidator(expectedProps);
    }
}

