/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.addressbook.service;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.HandlerChain;
import be.ehealth.technicalconnector.ws.domain.HandlerPosition;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import javax.xml.ws.handler.soap.SOAPHandler;

public final class TokenServiceFactory {
    private static final String PROP_ENDPOINT_ADDRESSBOOK = "endpoint.addressbook";
    private static final String PROP_VALIDATION_INCOMING_ADDRESSBOOK = "validation.incoming.message.addressbook";
    private static final String ADDRESSBOOK_XSD = "/XSD/ehealth-addressbook/XSD/ehealth-addressbook-protocol-1_0.xsd";
    private static Configuration config = ConfigFactory.getConfigValidatorFor((String[])new String[]{"endpoint.addressbook"});

    private TokenServiceFactory() {
        throw new UnsupportedOperationException("This factory should never be instantiated, only its static methods should be used");
    }

    public static GenericRequest getService(SAMLToken token) throws TechnicalConnectorException {
        GenericRequest genReq = new GenericRequest();
        genReq.setEndpoint(config.getProperty(PROP_ENDPOINT_ADDRESSBOOK));
        genReq.setCredential((Credential)token, TokenType.SAML);
        HandlerChain chain = new HandlerChain();
        if ("true".equalsIgnoreCase(config.getProperty(PROP_VALIDATION_INCOMING_ADDRESSBOOK))) {
            chain.register(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(3, new String[]{ADDRESSBOOK_XSD}));
        } else {
            chain.register(HandlerPosition.BEFORE, (SOAPHandler)new SchemaValidatorHandler(2, new String[]{ADDRESSBOOK_XSD}));
        }
        genReq.setDefaultHandlerChain();
        genReq.setHandlerChain(chain);
        return genReq;
    }
}

