package be.ehealth.businessconnector.test.ehbox.v3.session;

import be.ehealth.businessconnector.ehbox.v3.session.ServiceFactory;
import be.ehealth.businessconnector.test.ehbox.v3.util.EhboxTestDataBuilder;
import be.ehealth.businessconnector.test.ehbox.v3.util.EhboxTestUtilities;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.GetAllEhboxesMessagesListResponse;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

import be.ehealth.businessconnector.ehbox.api.domain.Addressee;
import be.ehealth.businessconnector.ehbox.api.domain.Document;
import be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage;
import be.ehealth.businessconnector.ehbox.api.utils.QualityType;
import be.ehealth.businessconnector.ehbox.v3.builders.BuilderFactory;
import be.fgov.ehealth.ehbox.consultation.protocol.v3.Message;
import be.fgov.ehealth.ehbox.publication.protocol.v3.SendMessageRequest;
import be.fgov.ehealth.ehbox.publication.protocol.v3.SendMessageResponse;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class EhboxV3SendToMultipleDestinationsIntegrationTest {

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysician").forUser("olivier").build();

    private static final String SSIN = "74123045193";

    private static String currentMessageId;


    @Test
    public void _00_sendMessage() throws Exception {

        DocumentMessage msg = new DocumentMessage();

        msg.getDestinations().addAll(Arrays.asList(new Addressee(SSIN, QualityType.DOCTOR_SSIN),
                new Addressee(SSIN, QualityType.PHARMACIST_SSIN)));

        Document doc = new Document();
        doc.setTitle("body");
        doc.setContent("body-eureka".getBytes());
        doc.setMimeType("text/html");
        doc.setFilename("body.html");
        msg.setBody(doc);

        Document annex = new Document();
        annex.setTitle("annex");
        annex.setContent("annex-eureka".getBytes());
        annex.setMimeType("application/octet-stream");
        annex.setFilename("annex.dump");
        msg.getAnnexList().add(annex);

        msg.setEncrypted(true);

        SendMessageRequest request = BuilderFactory.getSendMessageBuilder().buildMessage(msg);
        SendMessageResponse response = ServiceFactory.getEhealthBoxServiceV3().sendMessage(request);
        currentMessageId = response.getId();
    }

    @Test
    public void _01_getAllEhboxesMessagesList() throws Exception {
        GetAllEhboxesMessagesListResponse list = ServiceFactory.getEhealthBoxServiceV3()
                .getAllEhboxesMessagesList(BuilderFactory.getRequestBuilder().createAllEhboxesMessagesListRequest("INBOX"));
        Set<String> matchingMessages = new HashSet<>();
        for (Message message : list.getMessages()) {
            if (message.getMessageId().equals(currentMessageId)) {
                matchingMessages.add(message.getDestination().getQuality());
            }
        }
        ServiceFactory.getEhealthBoxServiceV3().getAllEhboxesMessagesList(BuilderFactory.getRequestBuilder().createAllEhboxesMessagesListRequest("INBOX"));
        Assert.assertTrue("Message should be in pharmacist profile's inbox", matchingMessages.contains("PHARMACIST"));
        Assert.assertTrue("Message should be in doctor profile's inbox", matchingMessages.contains("DOCTOR"));

    }

    @Test
    public void _02_deleteMessages() throws Exception {
        EhboxTestUtilities.deleteMessages("INBOX", EhboxTestDataBuilder.generateBoxId(SSIN, IdentifierType.SSIN.getType(IdentifierType.EHBOX), QualityType.DOCTOR_SSIN.getQuality()), currentMessageId);
        EhboxTestUtilities.deleteMessages("INBOX", EhboxTestDataBuilder.generateBoxId(SSIN, IdentifierType.SSIN.getType(IdentifierType.EHBOX), QualityType.PHARMACIST_SSIN.getQuality()), currentMessageId);
    }

}
