/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.chapterIV.exception;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.text.MessageFormat;

import be.ehealth.businessconnector.chapterIV.exception.ChapterIVBusinessConnectorException;
import be.ehealth.businessconnector.chapterIV.exception.ChapterIVBusinessConnectorExceptionValues;
import org.junit.Test;

import be.fgov.ehealth.errors.soa.v1.SOAErrorType;


/**
 * Test class for {@link ChapterIVBusinessConnectorException}
 * 
 * @author EHP
 * 
 */
public class ChapterIVBusinessConnectorExceptionTest {

    /**
     * Test with no text param
     */
    @Test
    public void testCivicsBusinessConnectorExceptionNoParam() {
        ChapterIVBusinessConnectorExceptionValues errorValue = ChapterIVBusinessConnectorExceptionValues.MALFORMED_URL;
        ChapterIVBusinessConnectorException error = new ChapterIVBusinessConnectorException(errorValue, new SOAErrorType());
        assertEquals(error.getErrorCode(), ChapterIVBusinessConnectorExceptionValues.MALFORMED_URL.getErrorCode());
        assertNotNull(error.getSOAError());
    }

    /**
     * Test with some params
     */
    @Test
    public void testCivicsBusinessConnectorExceptionParams() {
        ChapterIVBusinessConnectorExceptionValues errorValue = ChapterIVBusinessConnectorExceptionValues.MALFORMED_URL;
        ChapterIVBusinessConnectorException error = new ChapterIVBusinessConnectorException(errorValue, new SOAErrorType(), "test");
        assertEquals(error.getErrorCode(), MessageFormat.format(ChapterIVBusinessConnectorExceptionValues.MALFORMED_URL.getErrorCode(), "test"));
        assertNotNull(error.getSOAError());
    }

    /**
     * Test with a throwable
     */
    @Test
    public void testCivicsBusinessConnectorExceptionThrowable() {
        ChapterIVBusinessConnectorExceptionValues errorValue = ChapterIVBusinessConnectorExceptionValues.MALFORMED_URL;
        ChapterIVBusinessConnectorException error = new ChapterIVBusinessConnectorException(errorValue, new Throwable(), new SOAErrorType());
        assertEquals(error.getErrorCode(), ChapterIVBusinessConnectorExceptionValues.MALFORMED_URL.getErrorCode());
    }

}
