/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.config.impl;

import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.ConfigurationModule;
import be.ehealth.technicalconnector.exception.SilentInstantiationException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.utils.ConfigurableFactoryHelper;
import be.fedict.commons.eid.jca.BeIDProvider;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.ec.SunEC;

public class ConfigurationModuleSecurityProvider
implements ConfigurationModule {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationModuleSecurityProvider.class);
    private static final String PROP_CONFIGURATIONMODULESECURITYPROVIDER_LOADED = "be.ehealth.technicalconnector.config.impl.ConfigurationModuleSecurityProvider";
    private List<Provider> providersAdded = new ArrayList<Provider>();
    public static final String PROP_CLEANUP_ACTION_KEY = "be.ehealth.technicalconnector.config.impl.ConfigurationModuleSecurityProvider.cleanup.action";
    public static final String PROP_CLEANUP_ACTION_PARTIAL_ROOTKEY = "be.ehealth.technicalconnector.config.impl.ConfigurationModuleSecurityProvider.cleanup.action.partial";
    public static final String PROP_ADD_SECURITYPROVIDERS_ROOTKEY = "be.ehealth.technicalconnector.config.impl.ConfigurationModuleSecurityProvider.add.securityproviders";
    public static final String PROP_ADD_SECURITYPROVIDERS_ACTIVATED = "be.ehealth.technicalconnector.config.impl.ConfigurationModuleSecurityProvider.add.securityproviders.activated";
    public static final String PROP_ADD_SECURITYPROVIDERS_POSITION_KEY = "be.ehealth.technicalconnector.config.impl.ConfigurationModuleSecurityProvider.add.securityproviders.insertProviderAt";

    @Override
    public void init(Configuration config) {
        LOG.debug("Initializing ConfigurationModule {}", (Object)this.getClass().getName());
        String executed = System.getProperty(PROP_CONFIGURATIONMODULESECURITYPROVIDER_LOADED, "false");
        if ("false".equalsIgnoreCase(executed)) {
            this.removeSecurityProviders(config.getProperty(PROP_CLEANUP_ACTION_KEY, "none"), config);
            this.addSecurityProviders(config);
            this.printCurrentSecurityProviders();
            System.setProperty(PROP_CONFIGURATIONMODULESECURITYPROVIDER_LOADED, "true");
        }
    }

    private void printCurrentSecurityProviders() {
        if (LOG.isDebugEnabled()) {
            Provider[] providers = Security.getProviders();
            LOG.debug("Overview of security providers:");
            for (Provider prov : providers) {
                LOG.debug("\t. {} [{}]", (Object)prov.getName(), (Object)prov.getClass().getName());
            }
        }
    }

    private void addSecurityProviders(Configuration config) {
        String action = config.getProperty(PROP_ADD_SECURITYPROVIDERS_ACTIVATED);
        if (StringUtils.isEmpty((CharSequence)action)) {
            Security.removeProvider("SunEC");
            Security.addProvider((Provider)new BouncyCastleProvider());
            Security.addProvider((Provider)new BeIDProvider());
            Security.addProvider(new SunEC());
        } else if ("true".equalsIgnoreCase(action)) {
            try {
                ConfigurableFactoryHelper helper = new ConfigurableFactoryHelper(PROP_ADD_SECURITYPROVIDERS_ROOTKEY, null);
                List providerList = helper.getImplementations();
                String position = config.getProperty(PROP_ADD_SECURITYPROVIDERS_POSITION_KEY, "end");
                for (Provider provider : providerList) {
                    this.removeSecurityProvider(provider.getName());
                    if ("end".equals(position)) {
                        LOG.debug("Inserting provider {}", (Object)provider.getName());
                        Security.addProvider(provider);
                        continue;
                    }
                    if ("begin".equals(position)) {
                        LOG.debug("Inserting provider {} at position 1.", (Object)provider.getName());
                        Security.insertProviderAt(provider, 1);
                        continue;
                    }
                    if (StringUtils.isNumeric((CharSequence)position)) {
                        Integer positionId = Integer.parseInt(position);
                        LOG.debug("Inserting provider {} at position {}", (Object)provider.getName(), (Object)positionId);
                        Security.insertProviderAt(provider, positionId);
                        continue;
                    }
                    LOG.warn("Unsupported position value [" + position + "]");
                }
            }
            catch (TechnicalConnectorException e) {
                LOG.error("{}: {}", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
            }
        }
    }

    private void removeSecurityProviders(String action, Configuration config) {
        block3: {
            block2: {
                Provider[] providers;
                if (!"full".equals(action)) break block2;
                for (Provider prov : providers = Security.getProviders()) {
                    this.removeSecurityProvider(prov.getName());
                }
                break block3;
            }
            if (!"partial".equals(action)) break block3;
            List<String> providersToRemove = config.getMatchingProperties(PROP_CLEANUP_ACTION_PARTIAL_ROOTKEY);
            for (String providerName : providersToRemove) {
                this.removeSecurityProvider(providerName);
            }
        }
    }

    private void removeSecurityProvider(String providerName) {
        LOG.debug("Removing SecurityProvider with Name [{}]", (Object)providerName);
        Security.removeProvider(providerName);
    }

    @Override
    public void unload() throws TechnicalConnectorException {
        for (Provider provider : this.providersAdded) {
            LOG.debug("Removing provider {}", (Object)provider.getName());
            Security.removeProvider(provider.getName());
        }
        System.setProperty(PROP_CONFIGURATIONMODULESECURITYPROVIDER_LOADED, "false");
    }

    private Provider instantiate(String className) throws SilentInstantiationException {
        LOG.debug("Unloading ConfigurationModule {}", (Object)this.getClass().getName());
        try {
            Class<?> clazz = Class.forName(className);
            return (Provider)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SilentInstantiationException(e);
        }
        catch (InstantiationException e) {
            throw new SilentInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            throw new SilentInstantiationException(e);
        }
    }
}

