/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.business.mycarenetcommons.v3.mapper;

import be.ehealth.business.mycarenetcommons.v3.mapper.CommonInputMapper;
import be.ehealth.business.mycarenetdomaincommons.domain.CareProvider;
import be.ehealth.business.mycarenetdomaincommons.domain.CommonInput;
import be.ehealth.business.mycarenetdomaincommons.domain.Identification;
import be.ehealth.business.mycarenetdomaincommons.domain.Nihii;
import be.ehealth.business.mycarenetdomaincommons.domain.Origin;
import be.ehealth.business.mycarenetdomaincommons.domain.Party;
import be.ehealth.technicalconnector.config.util.domain.PackageInfo;
import be.fgov.ehealth.mycarenet.commons.core.v3.CareProviderType;
import be.fgov.ehealth.mycarenet.commons.core.v3.CommonInputType;
import be.fgov.ehealth.mycarenet.commons.core.v3.IdType;
import be.fgov.ehealth.mycarenet.commons.core.v3.LicenseType;
import be.fgov.ehealth.mycarenet.commons.core.v3.NihiiType;
import be.fgov.ehealth.mycarenet.commons.core.v3.OriginType;
import be.fgov.ehealth.mycarenet.commons.core.v3.PackageType;
import be.fgov.ehealth.mycarenet.commons.core.v3.PartyType;
import be.fgov.ehealth.mycarenet.commons.core.v3.RequestType;
import be.fgov.ehealth.mycarenet.commons.core.v3.ValueRefString;

public class CommonInputMapperImpl
extends CommonInputMapper {
    @Override
    public CommonInputType map(CommonInput input) {
        if (input == null) {
            return null;
        }
        CommonInputType commonInputType = new CommonInputType();
        commonInputType.setRequest(this.commonInputToRequestType(input));
        commonInputType.setOrigin(this.map(input.getOrigin()));
        commonInputType.setInputReference(input.getInputReference());
        return commonInputType;
    }

    @Override
    public OriginType map(Origin input) {
        if (input == null) {
            return null;
        }
        OriginType originType = new OriginType();
        originType.setSiteID(this.originToValueRefString(input));
        originType.setPackage(this.map(input.getPackageInfo()));
        originType.setCareProvider(this.map(input.getCareProvider()));
        originType.setSender(this.map(input.getSender()));
        OriginType target = this.doAfterMapping(originType);
        if (target != null) {
            return target;
        }
        return originType;
    }

    @Override
    public PackageType map(PackageInfo input) {
        if (input == null) {
            return null;
        }
        PackageType packageType = new PackageType();
        packageType.setName(this.packageInfoToValueRefString(input));
        packageType.setLicense(this.packageInfoToLicenseType(input));
        PackageType target = this.doAfterMapping(packageType);
        if (target != null) {
            return target;
        }
        return packageType;
    }

    @Override
    public CareProviderType map(CareProvider input) {
        if (input == null) {
            return null;
        }
        CareProviderType careProviderType = new CareProviderType();
        careProviderType.setNihii(this.map(input.getNihii()));
        careProviderType.setPhysicalPerson(this.map(input.getPhysicalPerson()));
        careProviderType.setOrganization(this.map(input.getOrganization()));
        return careProviderType;
    }

    @Override
    public NihiiType map(Nihii input) {
        if (input == null) {
            return null;
        }
        NihiiType nihiiType = new NihiiType();
        nihiiType.setValue(this.nihiiToValueRefString(input));
        nihiiType.setQuality(input.getQuality());
        NihiiType target = this.doAfterMapping(nihiiType);
        if (target != null) {
            return target;
        }
        return nihiiType;
    }

    @Override
    public IdType map(Identification input) {
        if (input == null) {
            return null;
        }
        IdType idType = new IdType();
        idType.setName(this.identificationToValueRefString(input));
        idType.setSsin(this.identificationToValueRefString1(input));
        idType.setCbe(this.identificationToValueRefString2(input));
        idType.setNihii(this.map(input.getNihii()));
        IdType target = this.doAfterMapping(idType);
        if (target != null) {
            return target;
        }
        return idType;
    }

    @Override
    public PartyType map(Party input) {
        if (input == null) {
            return null;
        }
        PartyType partyType = new PartyType();
        partyType.setPhysicalPerson(this.map(input.getPhysicalPerson()));
        partyType.setOrganization(this.map(input.getOrganization()));
        return partyType;
    }

    protected RequestType commonInputToRequestType(CommonInput commonInput) {
        if (commonInput == null) {
            return null;
        }
        RequestType requestType = new RequestType();
        if (commonInput.isTest() != null) {
            requestType.setIsTest(commonInput.isTest().booleanValue());
        }
        return requestType;
    }

    protected ValueRefString originToValueRefString(Origin origin) {
        if (origin == null) {
            return null;
        }
        ValueRefString valueRefString = new ValueRefString();
        valueRefString.setValue(origin.getSiteId());
        return valueRefString;
    }

    protected ValueRefString packageInfoToValueRefString(PackageInfo packageInfo) {
        if (packageInfo == null) {
            return null;
        }
        ValueRefString valueRefString = new ValueRefString();
        valueRefString.setValue(packageInfo.getPackageName());
        return valueRefString;
    }

    protected LicenseType packageInfoToLicenseType(PackageInfo packageInfo) {
        if (packageInfo == null) {
            return null;
        }
        LicenseType licenseType = new LicenseType();
        licenseType.setUsername(packageInfo.getUserName());
        licenseType.setPassword(packageInfo.getPassword());
        return licenseType;
    }

    protected ValueRefString nihiiToValueRefString(Nihii nihii) {
        if (nihii == null) {
            return null;
        }
        ValueRefString valueRefString = new ValueRefString();
        valueRefString.setValue(nihii.getValue());
        return valueRefString;
    }

    protected ValueRefString identificationToValueRefString(Identification identification) {
        if (identification == null) {
            return null;
        }
        ValueRefString valueRefString = new ValueRefString();
        valueRefString.setValue(identification.getName());
        return valueRefString;
    }

    protected ValueRefString identificationToValueRefString1(Identification identification) {
        if (identification == null) {
            return null;
        }
        ValueRefString valueRefString = new ValueRefString();
        valueRefString.setValue(identification.getSsin());
        return valueRefString;
    }

    protected ValueRefString identificationToValueRefString2(Identification identification) {
        if (identification == null) {
            return null;
        }
        ValueRefString valueRefString = new ValueRefString();
        valueRefString.setValue(identification.getCbe());
        return valueRefString;
    }
}

