/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.registration.session;

import be.cin.mycarenet.esb.common.v2.CareProviderType;
import be.cin.mycarenet.esb.common.v2.NihiiType;
import be.cin.mycarenet.esb.common.v2.ValueRefString;
import be.cin.nip.sync.reg.v1.BankAccountType;
import be.cin.nip.sync.reg.v1.RegistrantType;
import be.cin.nip.sync.reg.v1.RegistrationType;
import be.cin.nip.sync.reg.v1.Registrations;
import be.ehealth.business.mycarenetdomaincommons.builders.BlobBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.builders.RequestBuilderFactory;
import be.ehealth.business.mycarenetdomaincommons.domain.Blob;
import be.ehealth.business.mycarenetdomaincommons.domain.CareReceiverId;
import be.ehealth.business.mycarenetdomaincommons.domain.CommonInput;
import be.ehealth.business.mycarenetdomaincommons.domain.Routing;
import be.ehealth.business.mycarenetdomaincommons.util.McnConfigUtil;
import be.ehealth.businessconnector.registration.builder.RegistrationRequestBuilderFactory;
import be.ehealth.businessconnector.registration.builder.RequestBuilder;
import be.ehealth.businessconnector.registration.session.RegistrationSession;
import be.ehealth.businessconnector.registration.session.RegistrationSessionFactory;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.mycarenet.registration.protocol.v1.RegisterToMycarenetServiceRequest;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;
import org.joda.time.DateTime;
import org.junit.Test;


/**
 * Example of how to use the code
 * 
 * @author EH054
 */
public class CodeExampleUsage {

    @Test
    public void codeExampleTest() throws Exception {
        SessionInitializer.init("/be.ehealth.businessconnector.registration.test.properties");

        RequestBuilder mapper = RegistrationRequestBuilderFactory.getRequestObjectBuilder();

        CommonInput commonInput = RequestBuilderFactory.getCommonBuilder("mcn.registration").createCommonInput(McnConfigUtil.retrievePackageInfo("mcn.registration"), true, IdGeneratorFactory.getIdGenerator().generateId());

        // Request construction
        Registrations reg = new Registrations();
        reg.setStartDateTime(new DateTime());

        // Registrant part
        RegistrantType registrantType = new RegistrantType();
        CareProviderType careProvider = new CareProviderType();
        NihiiType nihiiType = new NihiiType();
        ValueRefString nihiiVRefString = new ValueRefString();

        nihiiVRefString.setValue(SessionUtil.getNihii11());
        nihiiType.setQuality("doctor");
        nihiiType.setValue(nihiiVRefString);

        careProvider.setNihii(nihiiType);
        registrantType.setCareProvider(careProvider);
        reg.setRegistrant(registrantType);

        // registration part
        RegistrationType registrationType = new RegistrationType();
        registrationType.setServiceName("GMD");

        BankAccountType bankAccountType = new BankAccountType();
        bankAccountType.setBic("NICABEBB");
        bankAccountType.setIban("BE39103123456719");
        registrationType.setBankAccount(bankAccountType);

        reg.setRegistration(registrationType);
        Blob blob = BlobBuilderFactory.getBlobBuilder("mcn.registration").build(ConnectorXmlUtils.toByteArray(reg));

        CareReceiverId careReceiver = new CareReceiverId(null);
        careReceiver.setMutuality("100");

        RegisterToMycarenetServiceRequest request = mapper.buildRegisterToMycarenetRequest(commonInput, new Routing(careReceiver, new DateTime()), blob, null);

        RegistrationSession session = RegistrationSessionFactory.getRegistrationSession();

        // throw a Technicalconnector exception if there is a problem during the operation no status to check so
        session.registerToMycarenetService(request);

    }
}
