/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.chapterIV.validators.impl;

import javax.xml.bind.JAXB;

import be.ehealth.businessconnector.chapterIV.validators.impl.KmehrValidatorImpl;
import org.junit.Test;

import be.ehealth.businessconnector.chapterIV.builders.impl.ConsultationBuilderImpl;
import be.ehealth.businessconnector.chapterIV.validators.KmehrValidator;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;


/**
 * Test class for {@link KmehrValidatorImpl}
 * 
 * @author EHP
 * 
 */
public class KmehrValidatorImplTest {
   
    /**
     * @throws Exception
     */
    @Test
    public void testValidXML() throws Exception {
        Kmehrmessage message = JAXB.unmarshal(ConsultationBuilderImpl.class.getResourceAsStream("/examples/persphysician-chapter4-consultation-request-with-ssin-kmehr.xml"), Kmehrmessage.class);
        KmehrValidator validator = new KmehrValidatorImpl();
        validator.validateKmehrMessage(message);
    }

}
