/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.session.renew;

import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.service.sts.utils.SAMLHelper;
import be.ehealth.technicalconnector.session.SessionItem;
import be.ehealth.technicalconnector.session.renew.AbstractRenewStrategy;
import org.joda.time.DateTime;

public class TokenExpiredRenew
extends AbstractRenewStrategy {
    @Override
    public void renew(SessionItem session) throws SessionManagementException {
        SAMLToken samlToken = session.getSAMLToken();
        DateTime end = SAMLHelper.getNotOnOrAfterCondition(samlToken.getAssertion());
        boolean valid = end.isAfterNow();
        if (!valid) {
            TokenExpiredRenew.executeReload(session, this.getCacheServices());
        }
    }
}

