﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.businessconnector.genericasync.test.util;
using be.ehealth.technicalconnector.enumeration;
using be.ehealth.technicalconnector.idgenerator;
using ikvm.extensions;
using javax.xml.ws.soap;
using NUnit.Framework;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using java.io;
using java.util;
using be.cin.mycarenet.esb.common.v2;
using be.cin.nip.async.generic;
using be.ehealth.business.mycarenetdomaincommons.builders;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.businessconnector.genericasync.builders;
using be.ehealth.businessconnector.genericasync.domain;
using be.ehealth.technicalconnector.utils;
using be.ehealth.technicalconnector.config.util.domain;
using be.ehealth.technicalconnector.config.util;
using be.ehealth.businessconnector.genericasync.mappers;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.business.mycarenetdomaincommons.util;
using org.mapstruct.factory;

namespace be.ehealth.businessconnector.genericasync.integration
{
	[TestFixture]
	public class GenAsyncIntegrationTest
	{

		private static String SERVICE_NAME = "dmg";


		[SetUp]
		public static void init() {
			SessionInitializer.init("be.ehealth.businessconnector.genericasync.test.properties",true,SupportedLanguages.NET.getAbbreviation());
		}

		[Test]
		public void testConsultationList(){
			// Params
			bool istest = true;

			InputStream xmlFile = ConnectorIOUtils.getResourceAsStream(".\\examples\\PostConsultationListeXml.xml");
			// requestIdentifier must be identical to second part of kmehr id in the test xml file!!!!
			// REPLACE STRING generated.id with actual value
			String identifierToUse = IdGeneratorFactory.getIdGenerator().generateId();
			String requestIdentifier = "$$generated.id$$";
			byte[] content = ConnectorIOUtils.getBytes(xmlFile);
			string fileContent = ConnectorIOUtils.toString(content, Charset.UTF_8);
			//replace the identifier seperately
			fileContent = TestUtil.replaceString(fileContent, requestIdentifier, identifierToUse);
			fileContent = TestUtil.fillOutPlaceHolders(fileContent);
			fileContent = fileContent.replaceAll(requestIdentifier, identifierToUse);
			content = ConnectorIOUtils.toBytes(fileContent, Charset.UTF_8);
			// now using same identifier in file and as input
			
			BlobBuilder bbuilder = BlobBuilderFactory.getBlobBuilder("genericasync");
			Blob blob = bbuilder.build(content, "deflate", "_" + UUID.randomUUID().toString(), "text/xml");
			String messageName = "GMD-CONSULT-HCP";
			blob.setMessageName(messageName);
			GenAsyncIntegrationTestUtil.basePostTest(new GenAsyncIntegrationTestUtil.PostParameter(blob, istest, SERVICE_NAME, false, null, "urn:be:cin:nip:async:generic:post:msg", identifierToUse));
		}

		[Test]
		public void testConfirmSuccessTackMessages(){
			PackageInfo packageInfo = McnConfigUtil.retrievePackageInfo(SERVICE_NAME);
			CommonBuilder commonBuilder = RequestBuilderFactory.getCommonBuilder(SERVICE_NAME);
			CommonInputMapper mapper = (CommonInputMapper) Mappers.getMapper(typeof(CommonInputMapper));
			OrigineType origin =  mapper.map(commonBuilder.createOrigin(packageInfo));
			// by not providing the type of message, we receive all messages.
			GetResponse getResponse = GenAsyncIntegrationTestUtil.get(origin, SERVICE_NAME);
			// normally you would also process the contents in messages received in getResponse.
			// this is skipped here
			java.util.List msgResponsesToConfirm = new ArrayList();
			java.util.List tackResponseToConfirm = new ArrayList();
			// only confirm successes
			tackResponseToConfirm.addAll(GenAsyncIntegrationTestUtil.selectTacksWithStatus(getResponse.getReturn().getTAckResponses(), GenericAsyncConstants.TACK_SUCCES));
			if (tackResponseToConfirm.isEmpty() && msgResponsesToConfirm.isEmpty()) {
				System.Console.WriteLine("no messages to confirm , WILL NOT EXECUTE CONFIRM");
			} else {
				System.Console.WriteLine("confirming " + tackResponseToConfirm.size() + " tackResponses and " + msgResponsesToConfirm.size() + " messageResponses");
				GenAsyncIntegrationTestUtil.confirm(origin, SERVICE_NAME, new java.lang.Integer(300), tackResponseToConfirm, msgResponsesToConfirm);

			}
		}

		[Test]
		[ExpectedException(typeof(SOAPFaultException))]
		public void confirmWithEmptyItems(){
			// test workaround for problem when no tackResponses or no MsgRsponses
			// will now throw exception javax.xml.ws.soap.SOAPFaultException: No values found in msgbox
			PackageInfo packageInfo = McnConfigUtil.retrievePackageInfo(SERVICE_NAME);
			CommonBuilder commonBuilder = RequestBuilderFactory.getCommonBuilder(SERVICE_NAME);
			CommonInputMapper mapper = (CommonInputMapper) Mappers.getMapper(typeof(CommonInputMapper));
			OrigineType origin = mapper.map(commonBuilder.createOrigin(packageInfo));
			java.util.List msgResponsesToConfirm = new ArrayList();
			java.util.List tackResponseToConfirm = new ArrayList();
			GenAsyncIntegrationTestUtil.confirm(origin, SERVICE_NAME, null, tackResponseToConfirm, msgResponsesToConfirm);
		}


		[Test]
		[ExpectedException(typeof(SOAPFaultException))]
		public void confirmWithOnlyDummyMessageResponse(){
			// test workaround for problem when no tackResponses or no MsgRsponses
			// will now throw exception javax.xml.ws.soap.SOAPFaultException: No values found in msgbox
			PackageInfo packageInfo = McnConfigUtil.retrievePackageInfo(SERVICE_NAME);
			CommonBuilder commonBuilder = RequestBuilderFactory.getCommonBuilder(SERVICE_NAME);
			CommonInputMapper mapper = (CommonInputMapper) Mappers.getMapper(typeof(CommonInputMapper));
			OrigineType origin = mapper.map(commonBuilder.createOrigin(packageInfo));
			java.util.List msgResponsesToConfirm = new ArrayList();
			MsgResponse dummyMsgResponse = new MsgResponse();
			be.cin.types.v1.Blob blob = new be.cin.types.v1.Blob();
			blob.setHashValue("hashValueToSend".getBytes());
			dummyMsgResponse.setDetail(blob);
			CommonOutputType dummyCommonOutput = new CommonOutputType();
			dummyCommonOutput.setInputReference("dummyInputReference");
			dummyMsgResponse.setCommonOutput(dummyCommonOutput);
			msgResponsesToConfirm.add(dummyMsgResponse);
			java.util.List tackResponseToConfirm = new ArrayList();
			GenAsyncIntegrationTestUtil.confirm(origin, SERVICE_NAME, null, tackResponseToConfirm, msgResponsesToConfirm);
		}

		[Test]
		[ExpectedException(typeof(SOAPFaultException))]
		public void confirmWithOnlyDummyTackValue(){
			// test workaround for problem when no tackResponses or no MsgRsponses
			// will now throw exception javax.xml.ws.soap.SOAPFaultException: No values found in msgbox
			PackageInfo packageInfo = McnConfigUtil.retrievePackageInfo(SERVICE_NAME);
			CommonBuilder commonBuilder = RequestBuilderFactory.getCommonBuilder(SERVICE_NAME);
			CommonInputMapper mapper = (CommonInputMapper) Mappers.getMapper(typeof(CommonInputMapper));
			OrigineType origin = mapper.map(commonBuilder.createOrigin(packageInfo));
			java.util.List msgResponsesToConfirm = new ArrayList();
			java.util.List tackResponseToConfirm = new ArrayList();
			TAckResponse dummyTackResponse = new TAckResponse();
			TAck dummyTack = new TAck();
			dummyTack.setValue("dummyTackValue".getBytes());
			dummyTackResponse.setTAck(dummyTack);
			tackResponseToConfirm.add(dummyTackResponse);
			GenAsyncIntegrationTestUtil.confirm(origin, SERVICE_NAME, null, tackResponseToConfirm, msgResponsesToConfirm);
		}

		[Test]
		public void testConfirmErrorTackMessages(){
			PackageInfo packageInfo = McnConfigUtil.retrievePackageInfo(SERVICE_NAME);
			CommonBuilder commonBuilder = RequestBuilderFactory.getCommonBuilder(SERVICE_NAME);
			CommonInputMapper mapper = (CommonInputMapper) Mappers.getMapper(typeof(CommonInputMapper));
			OrigineType origin = mapper.map(commonBuilder.createOrigin(packageInfo));
			// by not providing the type of message, we receive all messages.
			GetResponse getResponse = GenAsyncIntegrationTestUtil.get(origin, SERVICE_NAME);
			// normally you would also process the contents in messages received in getResponse.
			// this is skipped here
			java.util.List msgResponsesToConfirm = new ArrayList();
			java.util.List tackResponseToConfirm = new ArrayList();
			// only confirm errors
			tackResponseToConfirm.addAll(GenAsyncIntegrationTestUtil.selectTacksWithStatus(getResponse.getReturn().getTAckResponses(), GenericAsyncConstants.TACK_FAILURE));
			if (msgResponsesToConfirm.isEmpty()) {
				if (!tackResponseToConfirm.isEmpty()) {
					System.Console.WriteLine("tackResponses to confirm , but no messages to confirm , WILL NOT EXECUTE CONFIRM( only works when there are messages to confirm )");
				} else {
					System.Console.WriteLine("no messages to confirm , WILL NOT EXECUTE CONFIRM");
				}
			} else {
				System.Console.WriteLine("confirming " + tackResponseToConfirm.size() + " tackResponses and " + msgResponsesToConfirm.size() + " messageResponses");
				GenAsyncIntegrationTestUtil.confirm(origin, SERVICE_NAME, new java.lang.Integer(300), tackResponseToConfirm, msgResponsesToConfirm);

			}
		}
	}
}
