package be.ehealth.businessconnector.test.mycarenet.attestv2.builders.impl;

import be.ehealth.business.mycarenetdomaincommons.domain.Ssin;
import be.ehealth.businessconnector.mycarenet.attestv2.builders.impl.RequestObjectBuilderImpl;
import be.ehealth.businessconnector.mycarenet.attestv2.domain.CancelAttestBuilderRequest;
import be.ehealth.businessconnector.mycarenet.attestv2.domain.InputReference;
import be.ehealth.businessconnector.mycarenet.attestv2.domain.SendAttestBuilderRequest;
import be.ehealth.businessconnector.mycarenet.attestv2.exception.AttestBusinessConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.mycarenet.attest.protocol.v2.CancelAttestationRequest;
import be.fgov.ehealth.mycarenet.attest.protocol.v2.SendAttestationRequest;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class RequestObjectBuilderImplTest {

    @ClassRule
    public static SessionRule rule = SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysician").forUser("hannes").build();

    private static final String SSIN = "dummy_ssin";

    private RequestObjectBuilderImpl builder;

    @Before
    public void before() {
        this.builder = new RequestObjectBuilderImpl();
    }

    @Test
    public void buildSendAttestationRequest() throws AttestBusinessConnectorException, TechnicalConnectorException {
        InputReference inputReference = new InputReference();
        Ssin ssin = new Ssin(SSIN);
        SendAttestBuilderRequest builderRequest = this.builder.buildSendAttestationRequest(true, inputReference, ssin, new DateTime(), null);
        SendAttestationRequest request = builderRequest.getSendAttestationRequest();
        Assert.assertNotNull(request.getRouting());
    }

    @Test
    public void buildCancelAttestationRequest() throws AttestBusinessConnectorException, TechnicalConnectorException {
        InputReference inputReference = new InputReference();
        Ssin ssin = new Ssin(SSIN);
        CancelAttestBuilderRequest builderRequest = this.builder.buildCancelAttestationRequest(true, inputReference, ssin, new DateTime(), null);
        CancelAttestationRequest request = builderRequest.getCancelAttestationRequest();
        Assert.assertNull(request.getRouting());
    }

}
